/*****************************************************************************/
/* File name: String.java                                                    */
/* Purpose: additional things to work on strings                             */
/* Last modified: 25.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package util;

import java.io.*;
import java.lang.Math;
import java.text.*;
import java.util.*;
import general.Constants;

final

public
class

String

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/util/RCS/String.java,v 1.6 1999/04/25 21:09:28 vklimov Exp $";


  private static java.lang.String collatorRulesString = null;


  public
  String()
/*****************************************************************************/
/* Function name: String                                                     */
/* File name: String.java                                                    */
/* Purpose: constructor for the object String                                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 20.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* String */
/*---------------------------------------------------------------------------*/

    }
/*end of String*/


  public
  String( java.lang.String collatorRulesString )
/*****************************************************************************/
/* Function name: String                                                     */
/* File name: String.java                                                    */
/* Purpose: constructor for the object String                                */
/* Parameters: collatorRulesString                                           */
/* Returns:                                                                  */
/* Last modified: 20.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* String */
/*---------------------------------------------------------------------------*/

      this.collatorRulesString = collatorRulesString;

    }
/*end of String*/


  public
  static
  java.lang.String[]

  sort( java.lang.String strings[] )
/*****************************************************************************/
/* Function name: sort                                                       */
/* File name: String.java                                                    */
/* Purpose: to sort an array of strings                                      */
/* Parameters: strings                                                       */
/* Returns: sorted array of strings                                          */
/* Last modified: 25.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i,j;
      Collator sortCollator;
      CollationKey collationKeys[];
      CollationKey   tempCollationKey;

      boolean someKeySwapped = true;
                                                             /* sort */
/*---------------------------------------------------------------------------*/

      if ( collatorRulesString !=
               (java.lang.String) null )
        {
          try
            {
              sortCollator = (Collator) new
                RuleBasedCollator( collatorRulesString );
            }
          catch( ParseException e)
            {
              sortCollator = Collator.getInstance();
            }
        /*end of try-catch*/
        }
      else
        {
        sortCollator = Collator.getInstance();
        }
    /*end of if on null*/

      sortCollator.setStrength( Collator.TERTIARY );

      collationKeys = new CollationKey[ strings.length ];

      for (i=0; i<strings.length; i++)
        {
          collationKeys[i] =
            sortCollator.getCollationKey( strings[i] );
        }
    /*end of for-loop*/

      for ( i=strings.length;
            ( ( i >= 0 ) &&
              someKeySwapped
            );                 i--
          )
        {

          someKeySwapped = false;

          for ( j = 0; j<i-1; j++ )
            {
              if ( collationKeys[j].
                     compareTo( collationKeys[j+1] ) > 0
                 ) 
                {
                  tempCollationKey = collationKeys[j];
                  collationKeys[j] = collationKeys[j+1];
                  collationKeys[j+1] = tempCollationKey;
                  someKeySwapped = true;
                }
              else
                ;
            /*end of if on 0*/
            }
        /*end of inner for-loop on j*/
	}
    /*end of external for-loop on i*/

      for (i=0; i<strings.length; i++)
        {
          strings[i] =
            collationKeys[i].getSourceString();
        }
    /*end of for-loop*/

      return strings;

    }
/*end of sort*/


  public
  static
  int

  countChars( java.lang.String inString,
              char             charToCount )
/*****************************************************************************/
/* Function name: countChars                                                 */
/* File name: String.java                                                    */
/* Purpose: to count how many times a char occurs in a string                */
/* Parameters: inString                                                      */
/*             charToCount                                                   */
/* Returns: number of times the specified char is occuring in the string     */
/* Last modified: 16.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int    count = 0;
      int    length;
      int    nChar;
      int    beginningCharNumber = 0;
      boolean continueToLoop = true;
                                                       /* countChars */
/*---------------------------------------------------------------------------*/

      length = inString.length();

      nChar = inString.indexOf( charToCount,
                                beginningCharNumber );

      while ( ( nChar != general.Constants.JAVA_ERROR_CODE ) &&
              continueToLoop
            )
        {
          count++;
          beginningCharNumber = nChar + 1;

          if ( beginningCharNumber <= length-1 )
            {
            nChar = inString.indexOf( charToCount,
                                      beginningCharNumber );
            }
          else
            continueToLoop = false;
        /*end of if*/
        }
    /*end of while-loop*/

      return count;

    }
/*end of countChars*/


  public
  static
  java.lang.String
  removeChar( java.lang.String inString,
              char             charToRemove )
/*****************************************************************************/
/* Function name: removeChar                                                 */
/* File name: String.java                                                    */
/* Purpose: to remove first occurance of a char from a string                */
/* Parameters: inString                                                      */
/*             charToRemove                                                  */
/* Returns: the new String object with the first occurance                   */
/*          of the specified char removed                                    */
/* Last modified: 15.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int    nChar;
      java.lang.String outString;
                                                       /* removeChar */
/*---------------------------------------------------------------------------*/

      nChar = inString.indexOf( charToRemove );

      if (nChar < 0) /* nothing to remove */
        return inString;                                  /* return ! */
      else
        ;
    /*end of if*/

      outString =
        inString.substring(0,nChar) +
        inString.substring(nChar+1);

      return outString;

    }
/*end of removeChar*/



  public
  static
  java.lang.String

  removeAllSpecificChars( java.lang.String inString,
                          char             charToRemove )
/*****************************************************************************/
/* Function name: removeAllSpecificChars                                     */
/* File name: String.java                                                    */
/* Purpose: to remove all occurances of a specific char from a string        */
/* Parameters: inString                                                      */
/*             charToRemove                                                  */
/* Returns: the new String object with all occurances of the specified char  */
/*          removed                                                          */
/* Last modified: 15.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int    nChar;
      java.lang.String outString;
                                              /* removeAllSpecificChars */
/*---------------------------------------------------------------------------*/

      nChar = inString.indexOf( charToRemove );

      if (nChar < 0) /* nothing to remove */
        return inString;                                  /* return ! */
      else
        ;
    /*end of if*/

      outString = inString;

      do
        {
          outString = removeChar(
                        outString,
                        charToRemove );
          nChar = outString.indexOf( charToRemove );
        }
      while( nChar >= 0 );

      return outString;

    }
/*end of removeAllSpecificChars*/



  public
  static
  void

  stringAndNullsIntoByteArray( java.lang.String inString,
                               byte[] outByteArray        )
/*****************************************************************************/
/* Function name: stringAndNullsIntoByteArray                                */
/* File name: String.java                                                    */
/* Purpose: to put contents of a string into a byte array with at least one  */
/*          concluding null byte                                             */
/*          If the string is shorter than the array then the rest will be    */
/*          filled with null bytes                                           */
/*          If the string is longer than the array then only a part          */
/*          of the string will be put into the array. The last byte will be  */
/*          set to null                                                      */
/* Parameters: inString                                                      */
/*             outByteArray                                                  */
/* Returns:                                                                  */
/* Last modified: 04.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int i;
      int lengthOut = outByteArray.length;
      int lengthIn = 0;
      byte[] inByteArray;
                                           /* stringAndNullsIntoByteArray */
/*---------------------------------------------------------------------------*/

      util.Array.bytefill(
        outByteArray,
        general.Constants.NULL_BYTE );
      
      inByteArray = inString.getBytes();
      lengthIn = inByteArray.length;

      lengthIn = java.lang.Math.min( lengthOut, lengthIn );

      for( i=0; i<lengthIn; i++ )
        outByteArray[i] = inByteArray[i];
    /*end of for-loop*/

      outByteArray[ lengthOut-1 ] = general.Constants.NULL_BYTE;

    }
/*end of stringAndNullsIntoByteArray*/



  public
  static
  java.lang.String

  removeLeadingPathSeparator( java.lang.String inString )
/*****************************************************************************/
/* Function name: removeLeadingPathSeparator                                 */
/* File name: String.java                                                    */
/* Purpose: to remove leading file path separators from a string             */
/* Parameters: inString                                                      */
/* Returns: the string with leading path separators removed if any           */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int nameLength;
      StringBuffer inStringBuffer;
      int pathSeparatorIndexLast;
      int pathSeparatorLength = File.separator.length();

                                           /* removeLeadingPathSeparator */
/*---------------------------------------------------------------------------*/

      inStringBuffer = new
        StringBuffer( inString );

      while ( (inStringBuffer != null) &&
              (inStringBuffer.toString().
                 indexOf(
                   File.separator, 0 ) == 0)
            )
        {                                   /* force relative path */
          inStringBuffer =
            inStringBuffer.reverse();
          inStringBuffer.setLength(
            inStringBuffer.length() -
            pathSeparatorLength );
          inStringBuffer =
            inStringBuffer.reverse();

        }
    /*end of while-loop on absoluteNames*/

      return inStringBuffer.toString();

    }
/*end of removeLeadingPathSeparator*/



  public
  static
  java.lang.String

  removeTrailingPathSeparator( java.lang.String inString )
/*****************************************************************************/
/* Function name: removeTrailingPathSeparator                                */
/* File name: String.java                                                    */
/* Purpose: to remove trailing file path separators from a string            */
/* Parameters: inString                                                      */
/* Returns: the string with trailing path separators removed if any          */
/* Last modified: 24.11.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int nameLength;
      StringBuffer inStringBuffer;
      int pathSeparatorIndexLast;
      int pathSeparatorLength = File.separator.length();

                                           /* removeTrailingPathSeparator */
/*---------------------------------------------------------------------------*/

      inStringBuffer =
        new StringBuffer( inString );
      nameLength = inStringBuffer.length();

      pathSeparatorIndexLast =
        inStringBuffer.toString().
          lastIndexOf( File.separator,
                       nameLength -
                         pathSeparatorLength );


      while( ( pathSeparatorIndexLast +
               pathSeparatorLength      ==
               nameLength               )   &&
             (nameLength > 0)   &&
             (pathSeparatorIndexLast !=
              general.Constants.JAVA_ERROR_CODE )
           )
        {
          inStringBuffer.
            setLength(nameLength-pathSeparatorLength);
          nameLength -= pathSeparatorLength;
          pathSeparatorIndexLast =
            inStringBuffer.toString().
              lastIndexOf( File.separator,
                           nameLength -
                             pathSeparatorLength );

        }
    /*end of while-loop on slashes*/

      return inStringBuffer.toString();

    }
/*end of removeTrailingPathSeparator*/


  public
  static
  void

  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: String.java                                                    */
/* Purpose: to test the String class                                         */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 20.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      int count;
      char charToCount = '\0';
      java.lang.String stringsToSort[] = null;
                                                         /* main */
/*---------------------------------------------------------------------------*/

      if (args.length<3)
        {
          System.out.println( "Usage: java String <mode> <parameter> ...\n" );

          System.out.println( "For different modes:" );
          System.out.println( "\ncounting chars" );
          System.out.println(
            "Usage: java String count \"<char to count>\"\n" +
           "\"<string to count in>\" " +
           "\"[string2 to count in]\" ..." );
          System.out.println( "\nsorting strings" );
          System.out.println(
            "Usage: java String sort <string1> ..." );
          System.exit( 1 );                                       /* exit ! */
        }
      else
        ;
    /*end of if*/

      if ( args[0].equals( "count" ) )                        /* counting */
        {
          charToCount = args[1].charAt(0);
          for (i=2;i<args.length;i++)
            {
              count = countChars( args[i], charToCount );
              System.out.println( "looked for " + charToCount +
                                  " in the following string:\n" +
                                  args[i] +
                                  "\nfound: " + count + " times" );
            }
        /*end of for-loop*/
          System.exit( 0 );                                       /* exit ! */
        }
      else
        ;
    /*end of if on count*/

      if ( args[0].equals( "sort" ) )                        /* sorting */
        {
          stringsToSort = new
            java.lang.String[args.length-1];

          for (i=1;i<args.length;i++)
            {
              stringsToSort[i-1] = args[i];
            }
        /*end of for-loop*/
        }
      else
        ;
    /*end of if on count*/

      stringsToSort = sort( stringsToSort );

      System.out.println( "String, main: stringsToSort=" );
      for (i=0; i<stringsToSort.length; i++)
        System.out.println( stringsToSort[i] + " " );
    /*end of for-loop*/

      System.exit( 0 );                                       /* exit ! */

    }
/*end of main*/

} /*end of String */

/*****************************************************************************/
/* End of file: String.java                                                  */
/*****************************************************************************/
