/*****************************************************************************/
/* File name: Error.java                                                     */
/* Purpose: error reporting                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package util;

import java.awt.*;
import java.io.*;
import java.util.*;
import general.*;
import io.*;

public
class

Error

             implements jtar.Constants, general.Constants

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/util/RCS/Error.java,v 1.1 1999/05/04 17:01:12 vklimov Exp $";


  final static private java.lang.String WARND_TITLE   = "Warning";
  final static private java.lang.String WARND_TEXT    = "Warning: ";
  final static private int    WARND_ROWS    = 5;
  final static private int    WARND_COLUMNS = 55;

  final static private java.lang.String REPORT_AND_SET_EXIT_CODE_TITLE   = "Error";
  final static private java.lang.String REPORT_AND_SET_EXIT_CODE_TEXT    =
                                "*** Setting error code to\n" +
                                "CODE_INT_ERROR_FAILURE=" +
                                CODE_INT_ERROR_FAILURE + "\n";
  final static private int    REPORT_AND_SET_EXIT_CODE_ROWS    = 4;
  final static private int    REPORT_AND_SET_EXIT_CODE_COLUMNS = 50;

  final static private java.lang.String REPORT_AND_EXIT_TITLE   = "Exiting";
  final static private java.lang.String REPORT_AND_EXIT_TEXT    = "*** Exiting: ";
  final static private int    REPORT_AND_EXIT_ROWS    = 4;
  final static private int    REPORT_AND_EXIT_COLUMNS = 50;

  public static int exitCode = 0;

  static private Frame parentWindow;


  public
  Error( Frame parentWindow )
/*****************************************************************************/
/* Function name: Error                                                      */
/* File name: Error.java                                                     */
/* Purpose: constructor for the Error class                                  */
/* Parameters: parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 11.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                            /* Error */
/*---------------------------------------------------------------------------*/

      this.parentWindow = parentWindow;

    }
/*end of Error*/


  public
  static
  void
  warn( java.lang.String message )
/*****************************************************************************/
/* Function name: warn                                                       */
/* File name: Error.java                                                     */
/* Purpose: to report about an unrecoverable error and exit                  */
/* Parameters: message - error message string                                */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                            /* warn */
/*---------------------------------------------------------------------------*/

       io.TextDisplayingDialog warnd = new
         io.TextDisplayingDialog( parentWindow,
                                  WARND_TITLE,
                                  WARND_TEXT + message,
                                  WARND_ROWS,
                                  WARND_COLUMNS );
       warnd.show();
      

    }
/*end of warn*/


  public
  static
  void
  reportAndSetExitCode( java.lang.String message )
/*****************************************************************************/
/* Function name: reportAndSetExitCode                                       */
/* File name: Error.java                                                     */
/* Purpose: to report about an unrecoverable error and set the main exit code*/
/* Parameters: message - error message string                                */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                             /* reportAndSetExitCode */
/*---------------------------------------------------------------------------*/

      TextDisplayingDialog reportAndSetExitCodeDialog = new
        TextDisplayingDialog( parentWindow,
                              REPORT_AND_SET_EXIT_CODE_TITLE,
                              REPORT_AND_SET_EXIT_CODE_TEXT + message,
                              REPORT_AND_SET_EXIT_CODE_ROWS,
                              REPORT_AND_SET_EXIT_CODE_COLUMNS );
      reportAndSetExitCodeDialog.show();

      exitCode = CODE_INT_ERROR_FAILURE;

    }
/*end of reportAndSetExitCode*/


  public
  static
  void

  reportAndExit( java.lang.String message )
/*****************************************************************************/
/* Function name: reportAndExit                                              */
/* File name: Error.java                                                     */
/* Purpose: to report about an unrecoverable error and exit                  */
/* Parameters: message - error message string                                */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                 /* reportAndExit */
/*---------------------------------------------------------------------------*/

      TextDisplayingDialog reportAndExitDialog = new
        TextDisplayingDialog( parentWindow,
                              REPORT_AND_EXIT_TITLE,
                              REPORT_AND_EXIT_TEXT + message,
                              REPORT_AND_EXIT_ROWS,
                              REPORT_AND_EXIT_COLUMNS );
      reportAndExitDialog.show();

      System.exit( CODE_INT_ERROR_UNRECOVERABLE );

    }
/*end of reportAndExit*/


} /*end of class Error */

/*****************************************************************************/
/* End of file: Error.java                                                   */
/*****************************************************************************/

