/*****************************************************************************/
/* File name: DateTime.java                                                  */
/* Purpose: additional things to work on time                                */
/* Last modified: 20.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package util;

import java.util.Calendar;
import java.util.Date;
import java.text.DecimalFormat;

final

public
class

DateTime

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR03/util/RCS/DateTime.java,v 1.2 1998/12/10 20:41:49 root Exp $";


  private final static int    SECONDS_IN_A_DAY = 60 * 60 * 24;
  private final static java.lang.String DATE_COMPONENTS_SEPARATOR_STRING = "-";
  private final static java.lang.String DATE_TIME_COMPONENTS_SEPARATOR_STRING = " ";
  private final static java.lang.String TIME_COMPONENTS_SEPARATOR_STRING = ":";


  DateTime( )
/*****************************************************************************/
/* Function name: DateTime                                                   */
/* File name: DateTime.java                                                  */
/* Purpose: constructor for the object DateTime                              */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 03.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                          /* DateTime */
/*---------------------------------------------------------------------------*/

    }
/*end of DateTime*/


  public
  static
  java.lang.String
  isotime( long timeSeconds )
/*****************************************************************************/
/* Function name: isotime                                                    */
/* File name: DateTime.java                                                  */
/* Purpose: to convert UNIX era time in milliseconds to the time string      */
/* Parameters: timeSeconds                                                   */
/* Returns: date and time string                                             */
/* Last modified: 20.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      Calendar calendar = Calendar.getInstance();
      Date date;
      int daysToAdd;
      long secondsInDaysToAdd;
      int  secondsToAdd;
      int  year;
      int  month;
      int  day_of_month;
      int  hour;
      int  minute;
      int  second;
      DecimalFormat yearNumberFormat;
      DecimalFormat allOtherTwoDigitsDateComponentsNumberFormat;
      StringBuffer result = new StringBuffer( "" );

                                                       /* isotime */
/*---------------------------------------------------------------------------*/

      date = new Date( (long) 0 );
      calendar.setTime( date );
      daysToAdd = (int) (timeSeconds / (long) SECONDS_IN_A_DAY);
      secondsInDaysToAdd = (long) daysToAdd * (long) SECONDS_IN_A_DAY;
      secondsToAdd = (int) ( timeSeconds - secondsInDaysToAdd);

      calendar.add( Calendar.DAY_OF_YEAR,
                    daysToAdd             );
      calendar.add( Calendar.SECOND,
                    secondsToAdd          );

      year = calendar.get( Calendar.YEAR );
      month = calendar.get( Calendar.MONTH );
      day_of_month = calendar.get( Calendar.DATE );
      hour = calendar.get( Calendar.HOUR );
      minute = calendar.get( Calendar.MINUTE );
      second = calendar.get( Calendar.SECOND );

      yearNumberFormat = new DecimalFormat( "0000" );
      yearNumberFormat.setMinimumIntegerDigits(4);
      allOtherTwoDigitsDateComponentsNumberFormat =
        new DecimalFormat( "00" );
      allOtherTwoDigitsDateComponentsNumberFormat.
        setMinimumIntegerDigits(2);
 
      result.append( yearNumberFormat.format( year ) );
      result.append( DATE_COMPONENTS_SEPARATOR_STRING );
      result.append(
        allOtherTwoDigitsDateComponentsNumberFormat.
          format( month +1 ) );
      result.append( DATE_COMPONENTS_SEPARATOR_STRING );
      result.append(
        allOtherTwoDigitsDateComponentsNumberFormat.
          format( day_of_month ) );
      result.append( DATE_TIME_COMPONENTS_SEPARATOR_STRING );
      result.append(
        allOtherTwoDigitsDateComponentsNumberFormat.
          format( hour ) );
      result.append( TIME_COMPONENTS_SEPARATOR_STRING );
      result.append(
        allOtherTwoDigitsDateComponentsNumberFormat.
          format( minute ) );

      return result.toString();

    }
/*end of isotime*/

} /*end of DateTime */

/*****************************************************************************/
/* End of file: DateTime.java                                                */
/*****************************************************************************/

