/*****************************************************************************/
/* File name: Array.java                                                     */
/* Purpose: additional things to work on Arrays                              */
/* Last modified: 23.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package util;


final

public
class

Array

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR03/util/RCS/Array.java,v 1.2 1998/12/10 20:42:06 root Exp $";

  private final static java.lang.String BYTE_ARRAY_TO_STRING_HEX_SEPARATOR_STRING = " ";
  private final static java.lang.String BYTE_ARRAY_TO_STRING_HEX_PREFIX_STRING = "0x";
  private final static java.lang.String
                   BYTE_ARRAY_TO_STRING_HEX_PREFIX_FOR_SMALLS_STRING = "0x0";
  private final static java.lang.String BYTE_ARRAY_TO_STRING_HEX_LINE_SEP_STRING = "\n";
  private final static int    BYTE_ARRAY_TO_STRING_HEX_NUMBER_PER_LINE = 14;

  Array( )
/*****************************************************************************/
/* Function name: Array                                                      */
/* File name: Array.java                                                     */
/* Purpose: constructor for the object Array                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 03.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                            /* Array */
/*---------------------------------------------------------------------------*/

    }
/*end of Array*/


  public
  static
  java.lang.String
  byteArrayToStringOfHex( byte[] array,
                          int offset,
                          int length )
/*****************************************************************************/
/* Function name: byteArrayToStringOfHex                                     */
/* File name: Array.java                                                     */
/* Purpose: to convert an array bytes into a String containing Hex numbers   */
/*          for each of the bytes                                            */
/* Parameters: array to convert                                              */
/*             offset - index of the array element, from which to begin      */
/*             length - number of the elements to convert                    */
/* Returns: the string or                                                    */
/*          null in case of an error                                         */
/* Last modified: 23.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int i;
      int j;
      int arrayLength = array.length;
      StringBuffer result = new StringBuffer( "" );

                                              /* byteArrayToStringOfHex */
/*---------------------------------------------------------------------------*/

      if (arrayLength < offset)
        return null;                                   /* return ! */
      else
        ;
    /*end of if on offset*/

      if (arrayLength < offset + length)
        length = arrayLength - offset;
      else
        ;
    /*end of if on length*/

      j = 0;
      for (i = offset; i < length; i++)
        {
          if ( (array[i] <= 0xf) &&
               (array[i] >= 0)
             )
            {
              result.append(
                BYTE_ARRAY_TO_STRING_HEX_PREFIX_FOR_SMALLS_STRING );
            }
          else /* 2 hex digits */
            {
              result.append(
                BYTE_ARRAY_TO_STRING_HEX_PREFIX_STRING );
            }
        /*end of if on 0xf*/

          result.append(
            Integer.toHexString( array[i] ) +
            BYTE_ARRAY_TO_STRING_HEX_SEPARATOR_STRING );

          if (j++ >=
              BYTE_ARRAY_TO_STRING_HEX_NUMBER_PER_LINE)
            {
              result.append(
                BYTE_ARRAY_TO_STRING_HEX_LINE_SEP_STRING );
              j = 0;
            }
          else
            ;
        /*end of if on j*/

        }
    /*end of for-loop*/

      return result.toString();

    }
/*end of byteArrayToStringOfHex*/


  public
  static
  java.lang.String
  byteArrayToStringOfHex( byte[] array )
/*****************************************************************************/
/* Function name: byteArrayToStringOfHex                                     */
/* File name: Array.java                                                     */
/* Purpose: to convert an array bytes into a String containing Hex numbers   */
/*          for each of the bytes                                            */
/* Parameters: array to convert                                              */
/* Returns: the string                                                       */
/* Last modified: 22.10.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      int length = array.length;
      java.lang.String result;

                                              /* byteArrayToStringOfHex */
/*---------------------------------------------------------------------------*/

      result =
        byteArrayToStringOfHex( array,
                                0,
                                length );
      return result;

    }
/*end of byteArrayToStringOfHex*/


  public
  static
  void
  bytefill( byte[] array, byte value)
/*****************************************************************************/
/* Function name: bytefill                                                   */
/* File name: Array.java                                                     */
/* Purpose: to fill an array with a byte                                     */
/* Parameters: array to fill                                                 */
/*             value to fill with                                            */
/* Returns:                                                                  */
/* Last modified: 03.10.98                                                   */
/* Author: unknown - taken out of the Java FAQ:                              */
/*         http://www.afu.com/javafaq.html                                   */
/*****************************************************************************/
    {
      int len = array.length;
                                                       /* bytefill */
/*---------------------------------------------------------------------------*/

      if (len > 0)
        array[0] = value;
      else
        ;
    /*end of if*/

      for (int i = 1; i < len; i += i)
        System.arraycopy( array, 0, array, i,
                          ((len - i) < i) ? (len - i) : i);
    /*end of for-loop*/

    }
/*end of bytefill*/

} /*end of Array */

/*****************************************************************************/
/* End of file: Array.java                                                   */
/*****************************************************************************/

