/*****************************************************************************/
/* File name: System.java                                                    */
/* Purpose: some things specific to ms systems                               */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package msdos;

import util.*;

final

public
class

System

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/msdos/RCS/System.java,v 1.3 1999/05/04 17:00:58 vklimov Exp $";

  private static boolean alreadyCheckedSystem = false;
  private static boolean runningOnAMicrosoftSystem = false;

  System( )
/*****************************************************************************/
/* Function name: System                                                     */
/* File name: System.java                                                    */
/* Purpose: constructor for the object System                                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 26.11.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                       /* System */
/*---------------------------------------------------------------------------*/

    }
/*end of System*/


  public
  static
  boolean

  isMs()
/*****************************************************************************/
/* Function name: isMs                                                       */
/* File name: System.java                                                    */
/* Purpose: to check whether we are running on a ms system (as of now,       */
/*          I, personally, am acquainted with ms-dos and windows 3.11)       */
/* Parameters:                                                               */
/* Returns: true - if this is ms-dos or something alike, otherwise - false   */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      java.lang.String lineSeparatorString = null;
                                                              /* isMs */
/*---------------------------------------------------------------------------*/

      if (alreadyCheckedSystem)
        return runningOnAMicrosoftSystem;              /* return ! */
      else
        ;
    /*end of if*/

      alreadyCheckedSystem = true;
      if (java.io.File.pathSeparatorChar !=
          msdos.Constants.
            FILE_PATH_SEPARATOR_CHAR          )
        {
          runningOnAMicrosoftSystem = false;
          return false;                                  /* return ! */
        }
      else
        {
          try
            {
              lineSeparatorString =
                java.lang.System.getProperty(
                  general.Constants.
                    SYSTEM_PROPERTY_KEY_LINE_SEP );
              if ( !lineSeparatorString.
                      equals(
                        msdos.Constants.
                          LINE_SEPARATOR_STRING ) )
                {
                  runningOnAMicrosoftSystem = false;
                  return false;                          /* return ! */
                }
              else
                ;
            /*end of if on lineSeparatorString*/
            }
          catch( SecurityException e )
            {
              util.Error.warn(
                "msdos.System.isMs: " +
                e.getMessage() +
                ", can not get System " +
                "property line.separator" );
              runningOnAMicrosoftSystem = false;
              return false;                            /* return ! */
            }
        /*end of try-catch*/
            
        }
    /*end of if on pathSeparatorChar*/

      runningOnAMicrosoftSystem = true;
      return true;

    }
/*end of isMs*/



  public
  static
  void

  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: System.java                                                    */
/* Purpose: to test the System class                                         */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                         /* main */
/*---------------------------------------------------------------------------*/

    }
/*end of main*/

} /*end of System */

/*****************************************************************************/
/* End of file: System.java                                                  */
/*****************************************************************************/
