/*****************************************************************************/
/* File name: ListButton.java                                                */
/* Purpose: to provide a button to list contents of a tar archive            */
/*                                                                           */
/* Last modified: 18.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;


import java.awt.*;
import java.awt.event.*;
import general.*;
import io.*;


class

ListButton extends io.ResizedButton

                           implements ActionListener

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/ListButton.java,v 1.6 1999/05/19 04:13:09 vklimov Exp $";

  final private static String TITLE_FOR_DIALOG_LIST_TAR_FILE =
				"What tar file to list?";
  final private static String PROMPT_FOR_DIALOG_LIST_TAR_FILE =
				"Please choose a tar file to list";
  final private static String DESCR_FOR_DIALOG_LIST_TAR_FILE =
				"The tar file name";

  final static String FNAMED_TITLE   = "tar file name";
  final static String FNAMED_TEXT    = "listing contents of the tar " +
                                        "archive file:\n";
  final static int    FNAMED_ROWS    = 2;
  final static int    FNAMED_COLUMNS = 41;

  final static String RESULTD_TEXT    = "*** Error encountered while\n" +
                                        FNAMED_TEXT;

  Frame parentWindow = null;


  public
  ListButton( String label,
              int width, int heigth,
              Frame parentWindow      )
/*****************************************************************************/
/* Function name: ListButton                                                 */
/* File name: ListButton.java                                                */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/*             width                                                         */
/*             heigth                                                        */
/*             parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 07.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* ListButton */
/*---------------------------------------------------------------------------*/

      super( label );
      this.width = width;
      this.heigth = heigth;
      this.parentWindow = parentWindow;

    }
/*end of ListButton*/


  public
  ListButton( String label, int width, int heigth )
/*****************************************************************************/
/* Function name: ListButton                                                 */
/* File name: ListButton.java                                                */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/*             width                                                         */
/*             heigth                                                        */
/* Returns:                                                                  */
/* Last modified: 07.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* ListButton */
/*---------------------------------------------------------------------------*/

      super( label );
      this.width = width;
      this.heigth = heigth;

    }
/*end of ListButton*/


  public
  ListButton( String label )
/*****************************************************************************/
/* Function name: ListButton                                                 */
/* File name: ListButton.java                                                */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/* Returns:                                                                  */
/* Last modified: 06.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* ListButton */
/*---------------------------------------------------------------------------*/

      super( label );

    }
/*end of ListButton*/


  public
  ListButton()
/*****************************************************************************/
/* Function name: ListButton                                                 */
/* File name: ListButton.java                                                */
/* Purpose: constructor to create the button                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 06.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                           /* ListButton */
/*---------------------------------------------------------------------------*/

      super();

    }
/*end of ListButton*/


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: ListButton.java                                                */
/* Purpose: to process user initiated events                                 */
/* Parameters: event - incoming event object                                 */
/* Returns:                                                                  */
/* Last modified: 18.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      MultipleFileDialog  dialogListTarFile;
      String     listTarFileName;
      boolean    result = false;
      String paths[];
                                                         /* actionPerformed */
/*---------------------------------------------------------------------------*/

      if (parentWindow != null)
        {
          dialogListTarFile = new
            MultipleFileDialog( parentWindow,
                                TITLE_FOR_DIALOG_LIST_TAR_FILE,
                                PROMPT_FOR_DIALOG_LIST_TAR_FILE,
                                DESCR_FOR_DIALOG_LIST_TAR_FILE,
                                true,                             /* modal */
                                false,                            /* single */
                                java.awt.FileDialog.LOAD,    /*existing file*/
                                null                       );
          dialogListTarFile.show();

          paths = dialogListTarFile.getPaths();
          if (paths == (String[]) null)
            listTarFileName = (String) null;
          else
            listTarFileName = paths[0];
        /*end of if on null*/

          if (listTarFileName != null)
            {
              AllActions.file.flag = true;
              AllActions.archiveName =
                listTarFileName;
             if (AllActions.verbose.flag)
               {
                 TextDisplayingDialog fnamed = new
                   TextDisplayingDialog( parentWindow,
                                         FNAMED_TITLE,
                                         FNAMED_TEXT +
                                           AllActions.archiveName,
                                         FNAMED_ROWS,
                                         FNAMED_COLUMNS );
                 fnamed.show();
               }
             else
               ;
           /*end of if on verbose*/

             result =
               AllActions.table.action( null,
                                        null,
                                        null,
                                        parentWindow,
                                        false,         /* just to list */
                                        null           );

             if ( ! result )
               util.Error.warn( RESULTD_TEXT +
                             AllActions.archiveName );
             else
               ;
           /*end of if on verbose*/

	    }
          else
            ;
        /*end of if on null*/

        }
      else
        ;
    /*end of if on parentWindow*/

  } /* end of actionPerformed */

} /*end of ListButton */

/*****************************************************************************/
/* End of file: ListButton.java                                              */
/*****************************************************************************/
