/*****************************************************************************/
/* File name: Jtar.java                                                      */
/* Purpose: tar (GNU) translated into the Java language                      */
/*                                                                           */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;


import java.util.*;
import java.awt.*;
import java.awt.event.*;
import general.*;
import io.*;


class

Jtar extends Frame

     implements jtar.Constants, general.Constants, ItemListener

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/Jtar.java,v 1.14 1999/05/04 17:01:06 vklimov Exp $";


  final static String MAIN_WINDOW_TITLE                = "Jtar Application";
  final static int    INITIAL_MAIN_WINDOW_WIDTH        = 346;
  final static int    INITIAL_MAIN_WINDOW_HEIGTH       = 100;
  final static int    MAIN_OPTIONS_WIDTH               = 55;
  final static int    MAIN_OPTIONS_HEIGHT              = 30;

  final static String LIST_STRING    = "List";
  final static String EXTRACT_STRING = "Extract";
  final static String CREATE_STRING  = "Create";
  final static String ABOUT_STRING   = "About";
  final static String QUIT_STRING    = "Quit";

  final static String GZIP_STRING    = "GZIP compression/decompression";
  final static String VERBOSE_STRING = "Verbose";

  final static String VD_TITLE   = "Verbose";
  final static String VD_TEXT    = "Now running in verbose mode";
  final static int    VD_ROWS    = 1;
  final static int    VD_COLUMNS = 30;

  final static String GZIPD_TITLE   = "Gzip";
  final static String GZIPD_TEXT_ON = "GZIP compression/decompression is ON";
  final static String GZIPD_TEXT_OFF = "GZIP compression/decompression is OFF";
  final static int    GZIPD_ROWS    = 1;
  final static int    GZIPD_COLUMNS = 37;

  Checkbox gzipCheckbox;
  Checkbox verboseCheckbox;


  public
  Jtar()
/*****************************************************************************/
/* Function name: Jtar                                                       */
/* File name: Jtar.java                                                      */
/* Purpose: constructor for the Jtar class                                   */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {

      super();

      Panel generalPanel = new Panel();
      GridBagLayout generalLayout = new GridBagLayout();
      GridBagConstraints c = new GridBagConstraints();

      Panel buttonPanel;
      FlowLayout buttonPanelLayout;
      Panel checkboxPanel;

      ListButton    listButton;
      AboutButton   aboutButton;
      ExtractButton extractButton;
      CreateButton  createButton;
      QuitButton    quitButton;
                                                          /* Jtar */
/*---------------------------------------------------------------------------*/

      setTitle( MAIN_WINDOW_TITLE );
      setSize( INITIAL_MAIN_WINDOW_WIDTH,
               INITIAL_MAIN_WINDOW_HEIGTH );
      pack();
      setVisible( true );
      add( generalPanel );

      checkboxPanel  = new Panel();
      buttonPanel = new Panel();

      buttonPanelLayout = new FlowLayout();
      buttonPanel.setLayout( buttonPanelLayout );

      listButton    =
        new ListButton( LIST_STRING,
                        MAIN_OPTIONS_WIDTH,
                        MAIN_OPTIONS_HEIGHT, this );
      extractButton =
        new ExtractButton( EXTRACT_STRING,
                           MAIN_OPTIONS_WIDTH,
                           MAIN_OPTIONS_HEIGHT, this );
      createButton  =
        new CreateButton( CREATE_STRING,
                          MAIN_OPTIONS_WIDTH,
                          MAIN_OPTIONS_HEIGHT, this );
      aboutButton   =
        new AboutButton( ABOUT_STRING, this );
      quitButton    = new QuitButton( QUIT_STRING );

      verboseCheckbox = new Checkbox( VERBOSE_STRING );
      gzipCheckbox    = new Checkbox( GZIP_STRING );

      verboseCheckbox.addItemListener(
        new VerboseCheckboxItemListener( (Frame) this ) );
      gzipCheckbox.addItemListener(
        new GzipCheckboxItemListener( (Frame) this ) );
      createButton.addActionListener( createButton );
      extractButton.addActionListener( extractButton );
      listButton.addActionListener( listButton );
      aboutButton.addActionListener( aboutButton );
      quitButton.addActionListener( quitButton );

      buttonPanel.add( listButton    );
      buttonPanel.add( extractButton );
      buttonPanel.add( createButton  );
      buttonPanel.add( aboutButton   );
      buttonPanel.add( quitButton    );
      buttonPanel.validate();

      checkboxPanel.add( verboseCheckbox );
      checkboxPanel.add( gzipCheckbox );
      checkboxPanel.validate();

      generalPanel.setLayout( generalLayout );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.5;
      c.gridwidth = GridBagConstraints.REMAINDER; //end of row
      c.gridheight = GridBagConstraints.RELATIVE; //next to last
      generalLayout.setConstraints( buttonPanel, c );
      generalPanel.add( buttonPanel );

      c.fill = GridBagConstraints.BOTH; // resize the component in x and y
      c.weightx = 1;
      c.weighty = 0.5;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = GridBagConstraints.REMAINDER;
      generalLayout.setConstraints( checkboxPanel, c );
      generalPanel.add( checkboxPanel );

      generalPanel.validate();

    }
/*end of Jtar constructor*/


  public
  void

  itemStateChanged( ItemEvent event )
/*****************************************************************************/
/* Function name: itemStateChanged                                           */
/* File name: Jtar.java                                                      */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                  /* itemStateChanged */
/*---------------------------------------------------------------------------*/

    }

/*end of itemStateChanged*/


  public
  static
  void

  main( String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: Jtar.java                                                      */
/* Purpose: main method for the Jtar class                                   */
/* Parameters: agrument strings array - see the usage method in this file    */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                          /* main */
/*---------------------------------------------------------------------------*/

       Jtar jtarWindow = new Jtar();
       util.Error errorReporting = new util.Error( (Frame) jtarWindow );
    }
/*end of main*/


  class

  VerboseCheckboxItemListener

                         implements ItemListener
    {

      Frame parentWindow = null;

      VerboseCheckboxItemListener( Frame parentWindow )
/*****************************************************************************/
/* Function name: VerboseCheckboxItemListener                                */
/* Class name: VerboseCheckboxItemListener                                   */
/* File name: Jtar.java                                                      */
/* Purpose: constructor for the VerboseCheckboxItemListener class            */
/* Parameters: parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
                                          /* VerboseCheckboxItemListener */
/*---------------------------------------------------------------------------*/

          this.parentWindow = parentWindow;

        }
/*end of VerboseCheckboxItemListener*/


      public
      void

      itemStateChanged( ItemEvent event )
/*****************************************************************************/
/* Function name: itemStateChanged                                           */
/* Class name: VerboseCheckboxItemListener                                   */
/* File name: Jtar.java                                                      */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
                                                    /* itemStateChanged */
/*---------------------------------------------------------------------------*/

          if ( verboseCheckbox.getState() )
            {
              AllActions.verbose.flag = true;
              io.TextDisplayingDialog vd = new
                io.TextDisplayingDialog( parentWindow,
                                         VD_TITLE,
                                         VD_TEXT,
                                         VD_ROWS,
                                         VD_COLUMNS );
              vd.show();
            }
          else
            AllActions.verbose.flag = false;
        /*end of if on getState*/
        }
    /*end of itemStateChanged*/


    }
/*end of VerboseCheckboxItemListener*/


  class

  GzipCheckboxItemListener

                         implements ItemListener
    {

      Frame parentWindow = null;


      GzipCheckboxItemListener( Frame parentWindow )
/*****************************************************************************/
/* Function name: GzipCheckboxItemListener                                   */
/* Class name: GzipCheckboxItemListener                                      */
/* File name: Jtar.java                                                      */
/* Purpose: constructor for the GzipCheckboxItemListener class               */
/* Parameters: parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
                                            /* GzipCheckboxItemListener */
/*---------------------------------------------------------------------------*/

          this.parentWindow = parentWindow;

        }
/*end of GzipCheckboxItemListener*/


      public
      void

      itemStateChanged( ItemEvent event )
/*****************************************************************************/
/* Function name: itemStateChanged                                            */
/* Class name: GzipCheckboxItemListener                                      */
/* File name: Jtar.java                                                      */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 02.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
          String gzipText;
                                                      /* itemStateChanged */
/*---------------------------------------------------------------------------*/

          if ( gzipCheckbox.getState() )
            {
              AllActions.gzip.flag = true;
              gzipText = GZIPD_TEXT_ON;
            }
          else /* off */
            {
              AllActions.gzip.flag = false;
              gzipText = GZIPD_TEXT_OFF;
            }
        /*end of if on getState*/

            if (AllActions.verbose.flag)
              {
                io.TextDisplayingDialog gzipd = new
                  io.TextDisplayingDialog( parentWindow,
                                           GZIPD_TITLE,
                                           gzipText,
                                           GZIPD_ROWS,
                                           GZIPD_COLUMNS );
                gzipd.show();
              }
            else
              ;
          /*end of if on verbose*/
        }
    /*end of itemStateChanged*/


    }
/*end of GzipCheckboxItemListener*/

} /*end of Jtar */

/*****************************************************************************/
/* End of file: Jtar.java                                                    */
/*****************************************************************************/
