/*****************************************************************************/
/* File name: ExtractButton.java                                             */
/* Purpose: to provide a button to extract components from a tar archive     */
/*                                                                           */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import general.*;
import io.*;


class

ExtractButton extends io.ResizedButton

                           implements ActionListener
{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/ExtractButton.java,v 1.6 1999/05/23 22:34:42 vklimov Exp $";

  final private static String TITLE_FOR_DIALOG_EXTRACT_TAR_FILE =
				"From what tar file to extract?";
  final private static String PROMPT_FOR_DIALOG_EXTRACT_TAR_FILE =
				"Please choose a tar file to extract from";
  final private static String DESCR_FOR_DIALOG_EXTRACT_TAR_FILE =
				"The tar archive file";

  final private static String TITLE_FOR_DIALOG_ELEMENTS_TO_EXTRACT =
				"What archive elements to extract?";    
  final private static String PROMPT_FOR_DIALOG_ELEMENTS_TO_EXTRACT =
				"Please choose elements to extract";
  final private static String DESCR_FOR_DIALOG_ELEMENTS_TO_EXTRACT =
				"Elements to extract";

  final private static String TITLE_FOR_DIALOG_EXTRACT_ALL =
				"Extract everything?";    
  final private static String QUESTION_FOR_DIALOG_EXTRACT_ALL =
				"Extract all file elements?";    

  final static String FNAMED_TITLE   = "tar file name";
  final static String FNAMED_TEXT    = "extracting from the tar " +
                                        "archive file:\n";
  final static int    FNAMED_ROWS    = 2;
  final static int    FNAMED_COLUMNS = 41;

  final static String RESULTD_TEXT    = "*** Error encountered while\n" +
                                        FNAMED_TEXT;

  Frame parentWindow = null;


  public
  ExtractButton( String label,
                 int width, int heigth,
                 Frame parentWindow      )
/*****************************************************************************/
/* Function name: ExtractButton                                              */
/* File name: ExtractButton.java                                             */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/*             width                                                         */
/*             heigth                                                        */
/*             parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 12.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* ExtractButton */
/*---------------------------------------------------------------------------*/

      super( label );
      this.width = width;
      this.heigth = heigth;
      this.parentWindow = parentWindow;

    }
/*end of ExtractButton*/


  public
  ExtractButton( String label, int width, int heigth )
/*****************************************************************************/
/* Function name: ExtractButton                                              */
/* File name: ExtractButton.java                                             */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/*             width                                                         */
/*             heigth                                                        */
/* Returns:                                                                  */
/* Last modified: 12.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* ExtractButton */
/*---------------------------------------------------------------------------*/

      super( label );
      this.width = width;
      this.heigth = heigth;

    }
/*end of ExtractButton*/


  public
  ExtractButton( String label )
/*****************************************************************************/
/* Function name: ExtractButton                                              */
/* File name: ExtractButton.java                                             */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/* Returns:                                                                  */
/* Last modified: 12.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* ExtractButton */
/*---------------------------------------------------------------------------*/

      super( label );

    }
/*end of ExtractButton*/


  public
  ExtractButton()
/*****************************************************************************/
/* Function name: ExtractButton                                              */
/* File name: ExtractButton.java                                             */
/* Purpose: constructor to create the button                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 12.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                        /* ExtractButton */
/*---------------------------------------------------------------------------*/

      super();

    }
/*end of ExtractButton*/


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: ExtractButton.java                                             */
/* Purpose: to process user initiated events                                 */
/* Parameters: event - incoming event object                                 */
/* Returns:                                                                  */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      Vector commandLineOptionsVector;
      int i;
      MultipleFileDialog dialogExtractTarFile;
      MultipleFileDialog dialogElementsToExtractFromTarFile;
      YesNoDialog dialogExtractAll;
      String     elementsToExtract[];
      String     extractTarFileName;
      boolean    result = false;
      boolean    extractEverything = false;
      String paths[];
      RamFile ramFile = null;
                                                         /* actionPerformed */
/*---------------------------------------------------------------------------*/

      if (parentWindow != null)
        {
          dialogExtractTarFile = new
            MultipleFileDialog( parentWindow,
                                TITLE_FOR_DIALOG_EXTRACT_TAR_FILE,
                                PROMPT_FOR_DIALOG_EXTRACT_TAR_FILE,
                                DESCR_FOR_DIALOG_EXTRACT_TAR_FILE,
                                true,                             /* modal */
                                false,                            /* single */
                                java.awt.FileDialog.LOAD,    /*existing file*/
                                null                     );

          dialogExtractTarFile.show();

          paths = dialogExtractTarFile.getPaths();
          if (paths == (String[]) null)
            extractTarFileName = (String) null;
          else
            extractTarFileName = paths[0];
        /*end of if on null*/

          if (extractTarFileName != null)
            {
              AllActions.file.flag = true;
              AllActions.archiveName =
                extractTarFileName;
             if (AllActions.verbose.flag)
               {
                 TextDisplayingDialog fnamed = new
                   TextDisplayingDialog( parentWindow,
                                         FNAMED_TITLE,
                                         FNAMED_TEXT +
                                           AllActions.archiveName,
                                         FNAMED_ROWS,
                                         FNAMED_COLUMNS );
                 fnamed.show();
               }
             else
               ;
           /*end of if on verbose*/

             dialogExtractAll = new
               YesNoDialog( parentWindow,
                            TITLE_FOR_DIALOG_EXTRACT_ALL,
                            QUESTION_FOR_DIALOG_EXTRACT_ALL );

             dialogExtractAll.show();

             extractEverything =
               dialogExtractAll.answer();

             if (extractEverything)
               {
                 result =
                   AllActions.extract.action( null,
                                              null,
                                              null,
                                              parentWindow );

               }
             else /* extract only some file elements from the archive */
               {

                 ramFile = new RamFile();

                 result = 
                   AllActions.table.action( null,
                                            null,
                                            null,
                                            parentWindow,
                                            true,              /* fill up */
                                                    /* the ram filesystem */
                                            ramFile             );

                 dialogElementsToExtractFromTarFile = new
                   MultipleFileDialog( parentWindow,
                                       TITLE_FOR_DIALOG_ELEMENTS_TO_EXTRACT,
                                       PROMPT_FOR_DIALOG_ELEMENTS_TO_EXTRACT,
                                       DESCR_FOR_DIALOG_ELEMENTS_TO_EXTRACT,
                                       true,                       /* modal */
                                       ramFile                     );

                 dialogElementsToExtractFromTarFile.show();

                 elementsToExtract =
                   dialogElementsToExtractFromTarFile.getPaths();

                 if (elementsToExtract == null)
                   {
                     return;                                    /* return ! */
                   }
                 else                                  /* something chosen */
                   {
                     commandLineOptionsVector = new
                       Vector( elementsToExtract.length );

                     for (i=0;i<elementsToExtract.length;i++)
                       {
                         elementsToExtract[i] =
                           util.String.
                             removeLeadingPathSeparator(
                               elementsToExtract[i]      );
                         commandLineOptionsVector.
                           addElement( (Object) elementsToExtract[i] );
                       }
                   /*end of for-loop*/

                   }
               /*end of if*/

                 result =
                   AllActions.extract.action( commandLineOptionsVector,
                                              null,
                                              null,
                                              parentWindow );

               }
           /*end of if on extractEverything*/

             if ( ! result )
               util.Error.warn( RESULTD_TEXT +
                             AllActions.archiveName );
             else
               ;
           /*end of if on verbose*/

	    }
          else
            ;
        /*end of if on null*/

        }
      else
        ;
    /*end of if on parentWindow*/

  } /* end of actionPerformed */

} /*end of ExtractButton */

/*****************************************************************************/
/* End of file: ExtractButton.java                                           */
/*****************************************************************************/
