/*****************************************************************************/
/* File name: CreateButton.java                                              */
/* Purpose: to provide a button to create a tar archive                      */
/*                                                                           */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;


import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import general.*;
import io.*;


class

CreateButton extends io.ResizedButton

                           implements ActionListener
{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/CreateButton.java,v 1.7 1999/05/23 19:41:59 vklimov Exp $";

  final private static String TITLE_FOR_DIALOG_CREATE_TAR_FILE =
				"What tar file to create?";
  final private static String PROMPT_FOR_DIALOG_CREATE_TAR_FILE =
				"Please give a tar file name to create";
  final private static String DESCR_FOR_DIALOG_CREATE_TAR_FILE =
				"tar file name to create";

  final static String FNAMED_TITLE   = "tar file name";
  final static String FNAMED_TEXT    = "creating tar archive file:\n";
  final static int    FNAMED_ROWS    = 2;
  final static int    FNAMED_COLUMNS = 41;


  final static String TAR_FILE_NAME_DIALOG_TITLE   =
                                                "Please enter tar file name";
  final static String TAR_FILE_NAME_DIALOG_TEXT    =
            "In the next FileDialog please enter the future tar archive name";
  final static int    TAR_FILE_NAME_DIALOG_ROWS    = 2;
  final static int    TAR_FILE_NAME_DIALOG_COLUMNS = 77;

  final static String FILES_DIRS_TO_ARCHIVE_DIALOG_TITLE   =
                        "Files/directories to archive";
  final static String FILES_DIRS_TO_ARCHIVE_DIALOG_TEXT    = 
                        "Please choose " +
                        "files and/or directories to archive";
  final static String  FILES_DIRS_TO_ARCHIVE_DIALOG_SELECTED =
                        "Files and/or directories selected";
  final static boolean FILES_DIRS_TO_ARCHIVE_DIALOG_MODAL    = true;

  final static String RESULTD_TEXT    = "*** Error encountered while\n" +
                                        FNAMED_TEXT;

  Frame parentWindow = null;


  public
  CreateButton( String label,
                int width, int heigth,
                Frame parentWindow      )
/*****************************************************************************/
/* Function name: CreateButton                                               */
/* File name: CreateButton.java                                              */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/*             width                                                         */
/*             heigth                                                        */
/*             parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 14.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* CreateButton */
/*---------------------------------------------------------------------------*/

      super( label );
      this.width = width;
      this.heigth = heigth;
      this.parentWindow = parentWindow;

    }
/*end of CreateButton*/


  public
  CreateButton( String label, int width, int heigth )
/*****************************************************************************/
/* Function name: CreateButton                                               */
/* File name: CreateButton.java                                              */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/*             width                                                         */
/*             heigth                                                        */
/* Returns:                                                                  */
/* Last modified: 14.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* CreateButton */
/*---------------------------------------------------------------------------*/

      super( label );
      this.width = width;
      this.heigth = heigth;

    }
/*end of CreateButton*/


  public
  CreateButton( String label )
/*****************************************************************************/
/* Function name: CreateButton                                               */
/* File name: CreateButton.java                                              */
/* Purpose: constructor to create the button                                 */
/* Parameters: label                                                         */
/* Returns:                                                                  */
/* Last modified: 14.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* CreateButton */
/*---------------------------------------------------------------------------*/

      super( label );

    }
/*end of CreateButton*/


  public
  CreateButton()
/*****************************************************************************/
/* Function name: CreateButton                                               */
/* File name: CreateButton.java                                              */
/* Purpose: constructor to create the button                                 */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 14.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                        /* CreateButton */
/*---------------------------------------------------------------------------*/

      super();

    }
/*end of CreateButton*/


  public
  Vector

  getNamesVectorToArchive( Frame parentWindow )
/*****************************************************************************/
/* Function name: getNamesVectorToArchive                                    */
/* File name: CreateButton.java                                              */
/* Purpose: to get a vector of names of files and/or directories to archive  */
/* Parameters: parentWindow                                                  */
/* Returns: the vector of file and/or directory names to archive             */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      int lengthUserWorkingDirFullPath;
      Vector vectorNamesToArchive;
      String filesDirsToArchive[];
      String userWorkingDirFullPath;
      MultipleFileDialog filesDirsToArchiveDialog;

                                             /* getNamesVectorToArchive */
/*---------------------------------------------------------------------------*/

      vectorNamesToArchive = new Vector();

      filesDirsToArchiveDialog = new
        MultipleFileDialog( parentWindow,
                            FILES_DIRS_TO_ARCHIVE_DIALOG_TITLE,
                            FILES_DIRS_TO_ARCHIVE_DIALOG_TEXT,
                            FILES_DIRS_TO_ARCHIVE_DIALOG_SELECTED,
                            FILES_DIRS_TO_ARCHIVE_DIALOG_MODAL,
                            null                                    );
      filesDirsToArchiveDialog.show();

      filesDirsToArchive =
        filesDirsToArchiveDialog.getPaths();

      if (filesDirsToArchive == (String[]) null)
        return (Vector) null;                             /* return ! */
      else
        {

          userWorkingDirFullPath =
            util.Directory.
              getCurrentDirFullPath();
          if ( ! userWorkingDirFullPath.endsWith(
                   File.separator ) )
            userWorkingDirFullPath += File.separator;
          else
            ;
        /*end of if on File.separator*/

          lengthUserWorkingDirFullPath =
            userWorkingDirFullPath.length();

          for (i=0; i<filesDirsToArchive.length; i++)
            {
              if ( filesDirsToArchive[i].startsWith(
                     userWorkingDirFullPath )
                 )
                filesDirsToArchive[i] =
                  filesDirsToArchive[i].
                    substring(
                      lengthUserWorkingDirFullPath );
              else
                ;
           /*end of if on userWorkingDirFullPath*/

              vectorNamesToArchive.
                addElement( (Object) filesDirsToArchive[i] );
            }
        /*end of for-loop*/
        }
    /*end of if on null*/

      return vectorNamesToArchive;

  } /* end of getNamesVectorToArchive */


  public
  String
  getTarFileName( Frame parentWindow )
/*****************************************************************************/
/* Function name: getTarFileName                                             */
/* File name: CreateButton.java                                              */
/* Purpose: to get the tar archive name                                      */
/* Parameters: parentWindow                                                  */
/*                                                                           */
/* Note: java 1.0 version                                                    */
/*                                                                           */
/* Returns: the tar file name                                                */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      MultipleFileDialog dialogCreateTarFile;
      String tarFileNameToCreate;
      String paths[];
                                                         /* getTarFileName */
/*---------------------------------------------------------------------------*/

      dialogCreateTarFile = new
        MultipleFileDialog( parentWindow,
                            TITLE_FOR_DIALOG_CREATE_TAR_FILE,
                            PROMPT_FOR_DIALOG_CREATE_TAR_FILE,
                            DESCR_FOR_DIALOG_CREATE_TAR_FILE,
                            true,                              /* modal */
                            false,                            /* single */
                            java.awt.FileDialog.SAVE,       /* new file */
                            null                       );
      dialogCreateTarFile.show();

      paths = dialogCreateTarFile.getPaths();
      if (paths == (String[]) null)
        tarFileNameToCreate = (String) null;
      else
        tarFileNameToCreate = paths[0];
    /*end of if on null*/

      if (tarFileNameToCreate == (String) null)
        return ((String) null);                        /* return ! */
      else
        ;
    /*end of if on null*/

      return tarFileNameToCreate;

  } /* end of getTarFileName */


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: CreateButton.java                                              */
/* Purpose: to process user initiated events                                 */
/* Parameters: event - incoming event object                                 */
/*                                                                           */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      String     tarFileNameToCreate;
      Vector     namesVectorToArchive;
      boolean    result = false;

                                                         /* actionPerformed */
/*---------------------------------------------------------------------------*/

      if ( parentWindow != null)
        {
          tarFileNameToCreate =
            getTarFileName( parentWindow );

          if (tarFileNameToCreate != (String) null)
            {
              AllActions.file.flag = true;
              AllActions.archiveName =
                tarFileNameToCreate;
              if (AllActions.verbose.flag)
                {
                  TextDisplayingDialog fnamed = new
                    TextDisplayingDialog( parentWindow,
                                          FNAMED_TITLE,
                                          FNAMED_TEXT +
                                            AllActions.archiveName,
                                          FNAMED_ROWS,
                                          FNAMED_COLUMNS );
                  fnamed.show();
                }
              else
                ;
            /*end of if on verbose*/

              namesVectorToArchive =
                getNamesVectorToArchive( parentWindow );

              result =
                AllActions.create.action( namesVectorToArchive,
                                          null,
                                          null,
                                          parentWindow );

              if ( ! result )
                util.Error.warn( RESULTD_TEXT +
                            AllActions.archiveName );
              else
                ;
            /*end of if on result*/

	    }
          else
            ;
        /*end of if on null*/

        }
      else
        ;
    /*end of if on parentWindow*/

  } /* end of actionPerformed */

} /*end of CreateButton */

/*****************************************************************************/
/* End of file: CreateButton.java                                            */
/*****************************************************************************/
