/*****************************************************************************/
/* File name: Constants.java                                                 */
/* Purpose: constants for Jtar implenmented as an interface                  */
/* Last modified: 13.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;


public
interface

Constants

{

  /* $Header: /d/JTAR10/jtar/RCS/Constants.java,v 1.5 1998/12/20 00:11:44 vklimov Exp $ */

  final static char COMMAND_LINE_OPTION_TABLE   = 't';
  final static char COMMAND_LINE_OPTION_EXTRACT = 'x';
  final static char COMMAND_LINE_OPTION_CREATE  = 'c';
  final static char COMMAND_LINE_OPTION_FILE    = 'f';
  final static char COMMAND_LINE_OPTION_VERBOSE = 'v';
  final static char COMMAND_LINE_OPTION_GZIP    = 'z';
  final static char COMMAND_LINE_OPTION_INCREMENTAL = 'G';

  final static String COMMAND_LINE_OPTION_CHDIR_STRING = "-C";

  final static int N_MAX_MAIN_OPTIONS = 1;


  final static String TMAGIC = "ustar";    /* ustar */
  final static String TVERSION = "00";    /* 00 */
  final static int TMAGLEN = 6;
  final static int TVERSLEN = 2;

                                   /* OLDGNU_MAGIC uses both magic and     */
                                   /* version fields, which are contiguous */
                                   /* Found in an archive, it indicates    */
                                   /* an old GNU header format, which will */
                                   /* be hopefully become obsolescent.     */
                                   /* With OLDGNU_MAGIC, uname and gname   */
                                   /* are valid, though the header is      */
                                   /* not truly POSIX conforming           */

                                                       /* 7 bytes */

  final static String OLDGNU_MAGIC = "ustar  ";

                                   /* The standards committee allows only  */
                                   /* capital A through capital Z for      */
                                   /* user-defined expansion               */

                                    /* This is a dir entry that contains  */
                                    /* the names of files that were       */
                                    /* in the dir at the time the dump    */
                                    /* was made                           */

  final static byte GNUTYPE_DUMPDIR = 'D';

                                    /* Identifies the *next* file            */
                                    /* on the tape as having a long linkname */

  final static byte GNUTYPE_LONGLINK = 'K';

                                   /* Identifies the *next* file on the tape */
                                   /* as having a long name                  */

  final static byte GNUTYPE_LONGNAME = 'L';

                                   /* This is the continuation of a file     */
                                   /* that began on another volume           */

  final static byte GNUTYPE_MULTIVOL = 'M';

                                   /* For storing filenames that do not fit  */
                                   /* into the main header                   */

  final static byte GNUTYPE_NAMES = 'N';

                                   /* This is for sparse files.  */

  final static byte GNUTYPE_SPARSE = 'S';

                                   /* This file is a tape/volume header.     */
                                   /* Ignore it on extraction                */

  final static byte GNUTYPE_VOLHDR = 'V';


   /* header status */

  final static int HEADER_STILL_UNREAD = 0;             /* not read yet */
  final static int HEADER_SUCCESS      = 1;      /* read and checksummed OK */
  final static int HEADER_ZERO_BLOCK   = 2;    /* no header, got zero block */
  final static int HEADER_END_OF_FILE  = 3;      /* no header, got true EOF */
  final static int HEADER_FAILURE      = 4; /* bad  header, or bad checksum */

/* Values used in typeflag field.  */
  final static byte REGTYPE      = '0';            /* regular file */
  final static byte AREGTYPE = general.Constants.NULL_BYTE;  /* regular file */
  final static byte LNKTYPE  = '1';                /* link */
  final static byte SYMTYPE  = '2';                /* soft link on linux */
  final static byte CHRTYPE  = '3';                /* character special */
  final static byte BLKTYPE  = '4';                /* block special */
  final static byte DIRTYPE  = '5';                /* directory */
  final static byte FIFOTYPE = '6';                /* FIFO special */
  final static byte CONTTYPE = '7';                /* reserved */

  final static int READ_ERROR_MAX = 10;      /* Number of retries        */
                                             /* before giving up on read */

  final static int DEFAULT_BLOCKING = 20;    /* blocking size for archives.  */

  /* tar Header Block, overall structure */

  final static int BLOCKSIZE = 512;        /* tar files are made           */
                                           /* in basic blocks of this size */

  final static int DEFAULT_FORMAT = 0;      /* format to be decided later */
  final static int V7_FORMAT      = 1;      /* old V7 tar format */
  final static int OLDGNU_FORMAT  = 2;      /* GNU format before tar 1.12 */
  final static int POSIX_FORMAT   = 3;      /* restricted, pure POSIX format */
  final static int GNU_FORMAT     = 4;   /* POSIX format with GNU extensions */

                                                           /* byte offset */
  final static int HEADER_FIELD_LENGTH_NAME = 100;               /*   0 */
  final static int HEADER_FIELD_LENGTH_MODE = 8;                 /* 100 */
  final static int HEADER_FIELD_LENGTH_UID = 8;                  /* 108 */
  final static int HEADER_FIELD_LENGTH_GID = 8;                  /* 116 */
  final static int HEADER_FIELD_LENGTH_SIZE = 12;                /* 124 */
  final static int HEADER_FIELD_LENGTH_MTIME = 12;               /* 136 */
  final static int HEADER_FIELD_LENGTH_CHKSUM = 8;               /* 148 */
                          /* typeflag                   */       /* 156 */
  final static int HEADER_FIELD_LENGTH_LINKNAME = 100;           /* 157 */
  final static int HEADER_FIELD_LENGTH_MAGIC = 6;                /* 257 */
  final static int HEADER_FIELD_LENGTH_VERSION = 2;              /* 263 */
  final static int HEADER_FIELD_LENGTH_UNAME = 32;               /* 265 */
  final static int HEADER_FIELD_LENGTH_GNAME = 32;               /* 297 */
  final static int HEADER_FIELD_LENGTH_DEVMAJOR = 8;             /* 329 */
  final static int HEADER_FIELD_LENGTH_DEVMINOR = 8;             /* 337 */
  final static int HEADER_FIELD_LENGTH_PREFIX = 155;             /* 345 */
                                                                 /* 500 */
  final static int
    POSIX_HEADER_FIELD_LENGTH_UNUSED_AT_THE_END = 12;            /* 512 */

/* End of Format description.  */

                                 /* Sparse files are not supported in POSIX */
                                 /* ustar format.  For sparse files         */
                                 /* with a POSIX header, a GNU extra header */
                                 /* is provided which holds overall sparse  */
                                 /* information and a few sparse descriptors*/
                                 /* When an old GNU header replaces both    */
                                 /* the POSIX header and the GNU extra      */
                                 /* header, it holds some sparse descriptors*/
                                 /* too. Whether POSIX or not, if more      */
                                 /* sparse descriptors are still needed,    */
                                 /* they are put into as many successive    */
                                 /* sparse headers as necessary.            */
                                 /* The following constants tell how many   */
                                 /* sparse descriptors fit in each kind     */
                                 /* of header able to hold them.            */

  final static int SPARSES_IN_EXTRA_HEADER  = 16;
  final static int SPARSES_IN_OLDGNU_HEADER =  4;
  final static int SPARSES_IN_SPARSE_HEADER = 21;

  final static int SPARSE_DESCRIPTOR_FIELD_LENGTH_OFFSET = 12;
  final static int SPARSE_DESCRIPTOR_FIELD_LENGTH_NUMBYTES = 12;

  final static int OLDGNU_HEADER_FIELD_LENGTH_UNUSED_PAD1 = 345;
  final static int OLDGNU_HEADER_FIELD_LENGTH_ATIME = 12;
  final static int OLDGNU_HEADER_FIELD_LENGTH_CTIME = 12;
  final static int OLDGNU_HEADER_FIELD_LENGTH_OFFSET = 12;
  final static int OLDGNU_HEADER_FIELD_LENGTH_LONGNAMES = 4;
  final static int OLDGNU_HEADER_FIELD_LENGTH_REALSIZE = 12;
  final static int OLDGNU_HEADER_FIELD_LENGTH_UNUSED_AT_THE_END = 5;


  final static int CODE_INT_ERROR_FAILURE = 2;
  final static int CODE_INT_ERROR_UNRECOVERABLE = -1;

  final static int MASK_TO_KEEP_ONLY_PERMISSIONS_IN_MODE = 0xFFF;

  final static int MODE_MASK_USER_READ  = 0400;
  final static int MODE_MASK_USER_WRITE = 0200;

  final static int UNAME_FIELD_SIZE = 32;
  final static int GNAME_FIELD_SIZE = 32;
  final static int NAME_FIELD_SIZE  = 100;

  final static int DEFAULT_UID = 0;
  final static int DEFAULT_GID = 0;

  final static String MESSAGE_ACTION_STRING_EXTRACT = "extract";
  final static String MESSAGE_ACTION_STRING_ADD      = "add";

  final static int SP_VECTOR_INIT_SIZE = 10;

  final static String LONG_LINK_FILE_NAME = "././@LongLink";
  final static String CHKBLANKS      =      "        "; /* 8 blanks, no null */

  final static int JAVA_LAST_MODIFIED_TO_SECONDS_COEFF = 1000;

} /*end of Constants */

/*****************************************************************************/
/* End of file: Constants.java                                               */
/*****************************************************************************/
