/*****************************************************************************/
/* File name: Buffer.java                                                    */
/* Purpose: buffer work for Jtar                                             */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import java.awt.*;
import java.io.*;
import java.util.*;

class

Buffer

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/Buffer.java,v 1.6 1999/05/04 17:01:06 vklimov Exp $";

  final static private String NO_ARCHIVE_NAME     = "no archive name";
  final static private String INVALID_RECORD_SIZE = "invalid recordSize=";

  static File archiveFile;

  int     nBytesBuffer;
  byte[]  buffer;
  boolean eofEncountered = false;

                                     /* The String saveName contains        */
                                     /* the original long filename instead  */
                                     /* of the new, shorter mangled name    */
                                     /* The string saveName is only used    */
                                     /* in multi-volume mode when the file  */
                                     /* being processed is non-sparse;      */
                                     /* if a file is split between volumes, */
                                     /* the saveName is used in generating  */
                                     /* the LF_MULTIVOL record on the second*/
                                     /* volume.  (From Pierce Cantrell,     */
                                     /* 1991-08-13.)                        */

  String saveName = null;      /* name of the file we are currently writing */

  int saveTotsize;              /* total size of file we are writing, only */
                                 /* valid if saveName is non null           */
  int saveSizeleft;             /* where we are in the file we are writing,*/
                                 /* only valid if saveName is not null      */

  Buffer( )
/*****************************************************************************/
/* Function name: Buffer                                                     */
/* File name: Buffer.java                                                    */
/* Purpose: constructor for the Buffer object                                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 11.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                           /* Buffer */
/*---------------------------------------------------------------------------*/

      buffer = new byte[ AllActions.recordSize ];
      util.Array.bytefill( buffer,
                           general.Constants.NULL_BYTE );

    }
/*end of Buffer*/


  boolean
  open( Frame parentWindow )
/*****************************************************************************/
/* Function name: open                                                       */
/* File name: Buffer.java                                                    */
/* Purpose: to open an archive                                               */
/* Parameters: parentWindow                                                  */
/* Returns: true - if everything is all right, false - otherwise             */
/* Last modified: 03.05.99                                                   */
/* Author of the java version: Victor Klimov, 1999                           */
/*****************************************************************************/
    {
                                                            /* open */
/*---------------------------------------------------------------------------*/

      if (AllActions.recordSize <= 0)
        {
          util.Error.warn( INVALID_RECORD_SIZE +
                      AllActions.recordSize  );
          return false;                                       /* return ! */
        }
      else
        ;
    /*end of if*/

      if (AllActions.archiveName == null)
        {
          util.Error.warn( NO_ARCHIVE_NAME );
          return false;                                       /* return ! */
        }
      else
        ;
    /*end of if*/

      AllActions.currentFileName = null;
      AllActions.currentLinkName = null;

      return true;

    }
/*end of open*/


  void
  close( )
/*****************************************************************************/
/* Function name: close                                                      */
/* File name: Buffer.java                                                    */
/* Purpose: to close an archive                                              */
/* Parameters:                                                               */
/* Returns: true - if everything is all right, false - otherwise             */
/* Last modified: 16.10.98                                                   */
/* Author of the java version: Victor Klimov, 1998                           */
/*****************************************************************************/
    {
                                                            /* close */
/*---------------------------------------------------------------------------*/

    }
/*end of close*/


  int
  currentBlockOrdinal()
/*****************************************************************************/
/* Function name: currentBlockOrdinal                                        */
/* File name: Buffer.java                                                    */
/* Purpose: to return the number of the current block                        */
/* Parameters:                                                               */
/* Returns: the number                                                       */
/* Last modified: 12.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                /* currentBlockOrdinal */
/*---------------------------------------------------------------------------*/

      return 0; /* dummy method */

    }
/*end of currentBlockOrdinal*/


} /*end of class Buffer */

/*****************************************************************************/
/* End of file: Buffer.java                                                  */
/*****************************************************************************/

