/*****************************************************************************/
/* File name: ActionTable.java                                               */
/* Purpose: to keep an option and a corresponding flag for Jtar              */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import java.awt.*;
import java.util.*;
import general.*;
import io.*;

class

ActionTable

                   extends ActionRead

     implements jtar.Constants, general.Constants

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/ActionTable.java,v 1.7 1999/05/23 19:41:17 vklimov Exp $";

  private final static String HEADER_DIALOG_TITLE   = "List";
  private final static int    HEADER_DIALOG_ROWS    = 23;
  private final static int    HEADER_DIALOG_COLUMNS = 77;

  private final static String LIST_COMPLETED_MSG = "\nList completed";

  ActionTable( char    option,
               boolean flag   )
/*****************************************************************************/
/* Function name: ActionTable                                                */
/* File name: ActionTable.java                                               */
/* Purpose: constructor for the ActionTable object                           */
/* Parameters: option - 't', 'x', 'c' etc                                    */
/*             flag - corresponding flag                                     */
/* Returns:                                                                  */
/* Last modified: 11.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                        /* ActionTable */
/*---------------------------------------------------------------------------*/

      super( option, flag );

    }
/*end of ActionTable*/


  boolean
  action( Vector commandLineOptionsVector,
          Header dummyTarHeader,
          BufferRead dummyReadBuffer,
          Frame parentWindow,
          boolean fillFileSystem,
          io.RamFile ramFileSystem          )
/*****************************************************************************/
/* Function name: action to list archive members                             */
/* File name: ActionTable.java                                               */
/* Purpose: to list elements of a tar archive                                */
/* Parameters: commandLineOptionsVector - vector, containig strings          */
/*                                 of command line arguments to Jtar         */
/*             dummyTarHeader                                                */
/*             dummyReadBuffer                                               */
/*             parentWindow                                                  */
/*             fillFileSystem - if true, we won't list, we just fill         */
/*                              the contents of the RamFile object           */
/*             ramFileSystem - must me not null if fillFileSystem is true    */
/* Returns: true - if everything is all right, false - otherwise             */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      io.TextDisplayingDialog headerListDialog = null;
      int size = 0;
      int written = 0;
      boolean check = false;
      Block dataBlock = null;
      boolean readOK = true;
      boolean resultSuperAction = true;

      BufferRead readBuffer = new BufferRead();
      Header tarHeader = new Header();

      boolean isextended = false;        /* to remember if currentHeader */
                                         /* is extended                   */

                                                          /* action */
/*---------------------------------------------------------------------------*/


      if ( (fillFileSystem == true) &&
           (ramFileSystem == null)
         )
        {
          return false;                                  /* return ! */
        }
      else
        ;
    /*end of if on null*/

      readOK =
        readBuffer.open( parentWindow );

      if (!readOK)
        return false;                                  /* return ! */
      else
        ;
    /*end of if on readOK*/

      headerListDialog = new
        io.TextDisplayingDialog( parentWindow,
                                 HEADER_DIALOG_TITLE,
                              "",      /* originally nothing to display */
                                 HEADER_DIALOG_ROWS,
                                 HEADER_DIALOG_COLUMNS,
                              false /* not modal, don't wait */ );

      if (fillFileSystem != true)
        {
          headerListDialog.show();
        }
      else
        ;
    /*end of if on true*/

      while( true )
        {
          resultSuperAction =
            super.action( commandLineOptionsVector,
                          tarHeader,
                          readBuffer,
                          parentWindow              );

          if ( (tarHeader.status == HEADER_ZERO_BLOCK) ||
               (tarHeader.status == HEADER_END_OF_FILE) ||
               (tarHeader.status == HEADER_FAILURE)
             )

            break;                                          /* break ! */

          else
            ;
        /*end of if on status*/

                                                  /* Print the header block */
          tarHeader.decodeHeader( false ); /* no user group */
          tarHeader.printHeader( (Buffer) readBuffer,
                                 headerListDialog,
                                 fillFileSystem,
                                 ramFileSystem        );

          if (AllActions.incremental.flag &&
              tarHeader.currentHeader.
                               typeflag == GNUTYPE_DUMPDIR)
            {
              readBuffer.
                permitToFillUpNewCurrentBlock();

              if (AllActions.multiVolume)
                {
                  readBuffer.saveName = AllActions.currentFileName;
                  readBuffer.saveTotsize =
                    AllActions.currentStat.size;
                }
              else
                ;
            /*end of if on multiVolume*/

              for (size = AllActions.
                     currentStat.size;
                   size > 0; size -= written)
                {
                  if (AllActions.multiVolume)
                    readBuffer.saveSizeleft = size;
                  else
                    ;
                /*end of if on multiVolume*/

                  dataBlock = readBuffer.
                                 getCurrentDataBlock();

                  if (dataBlock == null)
                    {
                      util.Error.
                        reportAndSetExitCode(
                        "EOF in archive file"    );
                                  /* FIXME: What happens, then?  */
                      break;                                   /* break ! */
                    }
                  else
                    ;
                /*end of if on multiVolume*/

                  written = readBuffer.
                    availableSpaceAfter();

                  if (written > size)
                    written = size;
                  else
                    ;
                /*end of if on size*/

                  System.out.write( dataBlock.buffer,
                                    0, written         );

                  readBuffer.
                    permitToFillUpNewCurrentBlock();

                  check =
                    System.out.checkError();
                  if (check)
                    {
                      util.Error.
                        reportAndSetExitCode(
                          "Error in dumping"      );
                      readBuffer.skipFile( (size - written) );
                      break;                           /* break ! */
                    }
                  else
                    ;
                /*end of if on check*/
                }
            /*end of for-loop on size*/

              if (AllActions.multiVolume)
                readBuffer.saveName = null;
              else
                ;
            /*end of if on multiVolume*/

              System.out.println();
              System.out.flush();
              readBuffer.close();
              return true;                             /* return ! */

            }
          else
            ;
        /*end of if on GNUTYPE_DUMPDIR*/
                                      /* Check to see if we have an extended */
                                      /* header to skip over also            */

          if (tarHeader.currentHeader.
                             isextended != 0)
            isextended = true;
          else
            ;
        /*end of if on isextended*/
                                      /* Skip past the header in the archive */

          readBuffer.
            permitToFillUpNewCurrentBlock();
                                                 /* If we needed to skip     */
                                                 /* any extended headers, do */
                                                 /* so now, by reading       */
                                                 /* extended headers and     */
                                                 /* skipping past them       */
                                                 /* in the archive           */

          if (isextended)
            readBuffer.skipExtendedHeaders();
          else
            ;
        /*end of if on isextended*/

          if (AllActions.multiVolume)
            readBuffer.saveName =
              AllActions.currentFileName;
          else
            ;
        /*end of if on multiVolume*/
                                                  /* skip to the next header */
                                                  /* on the archive          */

          readBuffer.skipFile(
            AllActions.currentStat.size );

          if (AllActions.multiVolume)
            readBuffer.saveName = null;
          else
            ;
        /*end of if on multiVolume*/

        }
    /*end of while-loop*/

      if (fillFileSystem != true)
        {
          headerListDialog.append( LIST_COMPLETED_MSG );
        }
      else
        ;
    /*end of if on true*/

      readBuffer.close();
      Names.namesNotFound();            /* print names not found */

      return resultSuperAction;

    }
/*end of action*/


} /*end of class ActionTable */

/*****************************************************************************/
/* End of file: ActionTable.java                                             */
/*****************************************************************************/
