/*****************************************************************************/
/* File name: ActionRead.java                                                */
/* Purpose: to keep an option and a corresponding flag for Jtar              */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import java.awt.*;
import java.util.*;
import java.text.DecimalFormat;
import general.*;
import util.*;

class

ActionRead

                   extends Action

     implements jtar.Constants, general.Constants

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/jtar/RCS/ActionRead.java,v 1.4 1999/05/04 17:01:04 vklimov Exp $";


  ActionRead( char    option,
              boolean flag   )
/*****************************************************************************/
/* Function name: ActionRead                                                 */
/* File name: ActionRead.java                                                */
/* Purpose: constructor for the ActionRead object                            */
/* Parameters: option - 't', 'x', 'c' etc                                    */
/*             flag - corresponding flag                                     */
/* Returns:                                                                  */
/* Last modified: 15.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                     /* ActionRead */
/*---------------------------------------------------------------------------*/

      super( option, flag );

    }
/*end of ActionRead*/


  boolean
  action( Vector commandLineOptionsVector,
          Header tarHeader,
          BufferRead readBuffer,
          Frame parentWindow                )
/*****************************************************************************/
/* Function name: action                                                     */
/* File name: ActionRead.java                                                */
/* Purpose: empty method for archive reading                                 */
/* Parameters: commandLineOptionsVector - vector, containig strings          */
/*                                 of command line arguments to Jtar         */
/*             tarHeader                                                     */
/*             dummyReadBuffer                                               */
/*             parentWindow                                                  */
/* Returns: true - if everything is all right, false - otherwise             */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      DecimalFormat blockNumberFormat;
      int status = HEADER_STILL_UNREAD;
      int prevStatus;
      byte saveTypeflag;
      boolean isextended = false;

                                                          /* action */
/*---------------------------------------------------------------------------*/

      prevStatus = status;
      status = tarHeader.readHeader( readBuffer );
      tarHeader.status = status;

      switch( status )
        {
        case HEADER_STILL_UNREAD:
          util.Error.
            reportAndExit(                              /* abort ! */
                "HEADER_STILL_UNREAD" );

        case HEADER_SUCCESS:
                                          /* Valid header.  We should decode */
                                          /* next field (mode) first         */
                                          /* Ensure incoming names are       */
                                          /* null terminated                 */

                                          /* FIXME: This is a quick kludge   */
                                          /* before 1.12 goes out.  */
          AllActions.currentStat.mtime =
            Octal.fromOct( HEADER_FIELD_LENGTH_MTIME,
                            tarHeader.currentHeader.mtime );

                                         /* check whether we don't need */
                                         /* this current file           */
          if (!Names.nameMatch(
                 AllActions.currentFileName )    ||
               ( (long) AllActions.currentStat.mtime <
                  AllActions.newerMtime)   ||
               (AllActions.exclude && 
                Names.checkExclude(
                  AllActions.currentFileName) )
             )                                      /* garbage file, omit it */
            {
              isextended = false;

              if (tarHeader.
                    currentHeader.
                          typeflag == GNUTYPE_VOLHDR ||
                      tarHeader.
                        currentHeader.
                          typeflag == GNUTYPE_MULTIVOL ||
                      tarHeader.
                        currentHeader.
                          typeflag == GNUTYPE_NAMES)

                return true;                               /* return ! */

              else
                ;
            /*end of if on GNUTYPE*/

              if (AllActions.
                    showOmittedDirs &&
                  tarHeader.currentHeader.
                           typeflag == DIRTYPE)
                util.Error.warn( "Omitting " +
                            AllActions.currentFileName );
                                                         /* Skip past it   */
                                                         /* in the archive */
              if ( tarHeader.
                     currentHeader.isextended != 0 )
                isextended = true;
              else
                ;
            /*end of if*/

              saveTypeflag =
                tarHeader.currentHeader.typeflag;

              readBuffer.
                permitToFillUpNewCurrentBlock();

              if (isextended)
                readBuffer.
                  skipExtendedHeaders();
              else
                ;
            /*end of if on isextended*/
                                                  /* Skip to the next header */
                                                  /* on the archive          */
              if (saveTypeflag != DIRTYPE)
                readBuffer.skipFile(
                  AllActions.
                    currentStat.size );
              else
                ;
            /*end of if on DIRTYPE*/

              return true;                         /* return ! */

            }
        /*end of if on omitting the file*/

          return true;                             /* return ! */

        case HEADER_ZERO_BLOCK:
          if (AllActions.blockNumberOption)
            {
              blockNumberFormat = new DecimalFormat( "##########" );
              blockNumberFormat.setMinimumIntegerDigits(1);
              util.Error.warn( "ActionRead.action: block " +
                          blockNumberFormat.format(
                            readBuffer.currentBlockOrdinal() ) +
                          ": ** Block of NULs **" );
            }
          else
            ;
        /*end of if on blockNumberOption*/

          readBuffer.
            permitToFillUpNewCurrentBlock();
          status = prevStatus;

          return true;                               /* return ! */

        case HEADER_END_OF_FILE:
          if (AllActions.blockNumberOption)
            {
              blockNumberFormat = new DecimalFormat( "##########" );
              blockNumberFormat.setMinimumIntegerDigits(1);
              util.Error.warn( "ActionRead.action: block " +
                          blockNumberFormat.format(
                            readBuffer.currentBlockOrdinal() ) +
                          ": ** End of File **"                 );
            }
          else
            ;
        /*end of if on blockNumberOption*/

          break;                                       /* break ! */

        case HEADER_FAILURE:
          util.Error.warn( "Got HEADER_FAILURE");
                                               /* If the previous header */
                                               /* was good, tell them    */
                                               /* that we are skipping   */
                                               /* bad ones               */
          readBuffer.
            permitToFillUpNewCurrentBlock();

          switch( prevStatus )
            {
            case HEADER_STILL_UNREAD:
              util.Error.warn( "Hmm, this doesn't look" +
                          " like a tar archive");
                                                   /* Fall through.  */
            case HEADER_ZERO_BLOCK:
            case HEADER_SUCCESS:
              util.Error.warn( "Skipping to next " +
                          "file header" );
              break;                               /* break ! */

            case HEADER_END_OF_FILE:
            case HEADER_FAILURE:
                                            /* We are in the middle   */
                                            /* of a cascade of errors */

              break;                               /* break ! */
            }
        /*end of switch on prevStatus*/

          return false;                                 /* return ! */
        }
    /*end of switch on status*/

      return true;

    }
/*end of action*/


} /*end of class ActionRead */

/*****************************************************************************/
/* End of file: ActionRead.java                                              */
/*****************************************************************************/

