/*****************************************************************************/
/* File name: ActionCreate.java                                              */
/* Purpose: to create a tar archive                                          */
/* Last modified: 09.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package jtar;

import java.awt.*;
import java.io.*;
import java.util.*;
import general.*;
import io.*;

class

ActionCreate

                   extends Action

     implements jtar.Constants, general.Constants

{

  private final static String RCSID = "$Header: /d/JTAR12/jtar/RCS/ActionCreate.java,v 1.6 1999/05/09 22:17:18 vklimov Exp $";


  private final static String FILE_ARCHIVING_DIALOG_TITLE   = "Archiving";
  private final static int    FILE_ARCHIVING_DIALOG_ROWS    = 23;
  private final static int    FILE_ARCHIVING_DIALOG_COLUMNS = 77;


  String  dirNameToPrepend = null;
  boolean currentlyPrepending = false;
  int nameIndex = 0;
  int nNames = 0;

  ActionCreate( char    option,
                boolean flag   )
/*****************************************************************************/
/* Function name: ActionCreate                                               */
/* File name: ActionCreate.java                                              */
/* Purpose: constructor for the ActionCreate object                          */
/* Parameters: option - 't', 'x', 'c' etc                                    */
/*             flag - corresponding flag                                     */
/* Returns:                                                                  */
/* Last modified: 11.12.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                    /* ActionCreate */
/*---------------------------------------------------------------------------*/

      super( option, flag );

    }
/*end of ActionCreate*/


  void
  collectAndSortNames()
/*****************************************************************************/
/* Function name: collectAndSortNames                                        */
/* File name: ActionCreate.java                                              */
/* Purpose: to collect and sort file names                                   */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
                                              /* collectAndSortNames */
/*---------------------------------------------------------------------------*/

    }
/*end of collectAndSortNames*/


  void
  blankNameList()
/*****************************************************************************/
/* Function name: blankNameList                                              */
/* File name: ActionCreate.java                                              */
/* Purpose: to init the file name list to its original form                  */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
                                                    /* blankNameList */
/*---------------------------------------------------------------------------*/

    }
/*end of blankNameList*/


  String
  nameFromList()
/*****************************************************************************/
/* Function name: nameFromList                                               */
/* File name: ActionCreate.java                                              */
/* Purpose: to return a new file name to dump                                */
/* Parameters:                                                               */
/* Returns: the file name                                                    */
/* Last modified: 12.12.98                                                   */
/* Author of the Java translation: Victor Klimov, 1998                       */
/*****************************************************************************/
    {
      String fileName = null;
                                                     /* nameFromList */
/*---------------------------------------------------------------------------*/

      return fileName;

    }
/*end of nameFromList*/


  String
  nameNext( Vector  commandLineOptionsVector,
            boolean changeDirs                   )
/*****************************************************************************/
/* Function name: nameNext                                                   */
/* File name: ActionCreate.java                                              */
/* Purpose: to get next file name from the list of options                   */
/* Parameters: commandLineOptionsVector - vector, containig strings          */
/*                                 of command line arguments to Jtar         */
/*             changeDirs                                                    */
/* Returns: the file name or null if no more names left                      */
/* Last modified: 03.05.99                                                   */
/* Author of the java version: Victor Klimov, 1999                           */
/*****************************************************************************/
    {
      String source = null;
      StringBuffer fileNameWithPrefix;
      File   dirFile;
      boolean beginToPrependDirName = false;

                                                         /* nameNext */
/*---------------------------------------------------------------------------*/

      nNames = commandLineOptionsVector.size();

      while( nameIndex < nNames )
        {
          source = (String)
            commandLineOptionsVector.
              elementAt(nameIndex++);

          source =
            util.String.
              removeTrailingPathSeparator(
                source                     );

          if (beginToPrependDirName)
            {
              try
                {
                  dirFile = new File( source );
                  if ( dirFile.exists() )
                    {
                      dirNameToPrepend =
                        new String( source );
                      beginToPrependDirName = false;
                      currentlyPrepending = true;
                    }
                  else
                    util.Error.
                      reportAndExit(                            /* abort ! */
                        "directory \"" + source +
                        "\" does not exist, exiting" );
                /*end of if*/

                }
              catch( NullPointerException e)
                {
                  util.Error.
                    reportAndExit(                              /* abort ! */
                      e.getMessage() +
                      "\nnull directory name given as an option" );
                }
              catch( SecurityException e)
                {
                  util.Error.
                    reportAndExit(                              /* abort ! */
                      e.getMessage() );
                }
            /*end of try-catch*/
            }
          else /* previous vector element was not "-C" */
            {
              if ( changeDirs &&
                   source.equals(
                     COMMAND_LINE_OPTION_CHDIR_STRING )
                 )
                {
                  beginToPrependDirName = true;
                  currentlyPrepending = false;
                }
              else /* don't change dirs */
                {
                  source =
                    util.QuoteString.
                      unquoteString( source );
                  if (currentlyPrepending)
                    {
                      fileNameWithPrefix = new
                        StringBuffer( dirNameToPrepend );
                      fileNameWithPrefix.
                        append( File.separator );
                      fileNameWithPrefix.
                        append( source );
                      return fileNameWithPrefix.toString();     /* return ! */
                    }
                  else
                    return source;                              /* return ! */
                /*end of if*/
                }
            /*end of if on changeDirs*/
            }
        /*end of if on beginToPrependDirName*/
        }
    /*end of while-loop*/

      if ( (source != null) &&
           beginToPrependDirName)
        util.Error.
          reportAndExit(                              /* abort ! */
            "Missing file name after -C" );
      else
        ;
    /*end of if on null*/

      return source;                                 /* return ! */

    }
/*end of nameNext*/


  boolean
  action( Vector commandLineOptionsVector,
          Header dummyTarHeader,
          BufferRead dummyReadBuffer,
          Frame parentWindow               )
/*****************************************************************************/
/* Function name: action to create an archive                                */
/* File name: ActionCreate.java                                              */
/* Purpose: to create an archive                                             */
/* Parameters: commandLineOptionsVector - vector, containig strings          */
/*                                 of command line arguments to Jtar         */
/*             dummyTarHeader                                                */
/*             dummyReadBuffer                                               */
/*             parentWindow                                                  */
/* Returns: true - if everything is all right, false - otherwise             */
/* Last modified: 09.05.99                                                   */
/* Author of the Java translation: Victor Klimov, 1999                       */
/*****************************************************************************/
    {
      int i;
      boolean readOK = true;
      String fileToDumpName;

      BufferWrite writeBuffer = new BufferWrite();
      Header tarHeader = new Header();
      io.TextDisplayingDialog filesArchivingDisplayDialog = null;
                                                             /* action */
/*---------------------------------------------------------------------------*/

      if (commandLineOptionsVector == null)
        {
          return false;                                  /* return ! */
        }
      else
        ;
    /*end of if on null*/

      readOK =
        writeBuffer.open( parentWindow );

      if (!readOK)
        {
          return false;                                  /* return ! */
        }
      else
        ;
    /*end of if on readOK*/

      if (AllActions.incremental.flag)
        {
          /* to implement in the future */
        }
      else /* not incremental */
        {
          nameIndex = 0;
          fileToDumpName =
            nameNext( commandLineOptionsVector,
                      true /* change dirs */        );

          filesArchivingDisplayDialog = new
            io.TextDisplayingDialog( parentWindow,
                                     FILE_ARCHIVING_DIALOG_TITLE,
                                  "",      /* originally nothing to display */
                                     FILE_ARCHIVING_DIALOG_ROWS,
                                     FILE_ARCHIVING_DIALOG_COLUMNS,
                                       /* not modal, don't wait for anything */
                                  false                    );
          filesArchivingDisplayDialog.show();

          i=-1;
          while( fileToDumpName != null )
            {
              i++;

              if (AllActions.verbose.flag)
                filesArchivingDisplayDialog.append(
                  "dumping file: " +
                    fileToDumpName +
                  "\n" );
              else
                ;
            /*end of if on verbose*/

              writeBuffer.
                dumpFile( fileToDumpName,
                          true, /*top level call*/
                          writeBuffer,
                          tarHeader,
                          filesArchivingDisplayDialog );
              fileToDumpName =
                nameNext( commandLineOptionsVector,
                          true /* change dirs */        );
            }
        /*end of while-loop*/
        }
    /*end of if on incremental*/

      writeBuffer.writeEot();
      writeBuffer.close();

      if (filesArchivingDisplayDialog != null)
        filesArchivingDisplayDialog.append(
          "tar archive " + AllActions.archiveName +
          " created\n"                               );
      else
        ;
    /*end of if on null*/

      return true;

    }
/*end of action*/


} /*end of class ActionCreate */

/*****************************************************************************/
/* End of file: ActionCreate.java                                            */
/*****************************************************************************/
