/*****************************************************************************/
/* File name: YesNoDialog.java                                               */
/* Purpose: to provide a dialog to display a question and get a yes or no    */
/*          answer from the user                                             */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.awt.*;
import java.awt.event.*;


public
class

YesNoDialog extends Dialog

                            implements ActionListener

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/io/RCS/YesNoDialog.java,v 1.1 1999/05/23 20:51:34 vklimov Exp $";

  private final static java.lang.String UPPER_PANEL_LOCATION_STRING = "Center";
  private final static java.lang.String LOWER_PANEL_LOCATION_STRING = "South";

  private final static java.lang.String YES_BUTTON_LABEL_STRING = "Yes";
  private final static java.lang.String NO_BUTTON_LABEL_STRING = "No";
  private final static int              LOWER_PANEL_LAYOUT_HGAP = 21;

  private final static java.lang.String LOWER_PANEL_YES_PLACE = "West";
  private final static java.lang.String LOWER_PANEL_NO_PLACE   = "East";

  private boolean answerBoolean = false;

  Button yesButton;
  Button noButton;

  Label questionLabel;


  public
  YesNoDialog( Frame parentWindow,
               java.lang.String title,
               java.lang.String questionText )
/*****************************************************************************/
/* Function name: YesNoDialog                                                */
/* File name: YesNoDialog.java                                               */
/* Purpose: constructor for the YesNoDialog class                            */
/* Parameters: parentWindow                                                  */
/*             title                                                         */
/*             questionText                                                  */
/* Returns:                                                                  */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                     /* YesNoDialog */
/*---------------------------------------------------------------------------*/

      super( parentWindow, title, true );

      BorderLayout lowerPanelLayout = new BorderLayout();
      lowerPanelLayout.setHgap( LOWER_PANEL_LAYOUT_HGAP );

      Panel upperPanel = new Panel();
      Panel lowerPanel = new Panel();

      questionLabel = new Label( questionText );

      upperPanel.add( questionLabel );
      add( UPPER_PANEL_LOCATION_STRING, upperPanel );

      yesButton = new Button( YES_BUTTON_LABEL_STRING );
      yesButton.addActionListener( this );
      lowerPanel.add( yesButton,
                      LOWER_PANEL_YES_PLACE );

      noButton = new Button( NO_BUTTON_LABEL_STRING );
      noButton.addActionListener( this );
      lowerPanel.add( noButton,
                      LOWER_PANEL_NO_PLACE );
      add( LOWER_PANEL_LOCATION_STRING, lowerPanel );

      pack();

    }
/*end of YesNoDialog*/




  public
  YesNoDialog( Frame parentWindow )
/*****************************************************************************/
/* Function name: YesNoDialog                                                */
/* File name: YesNoDialog.java                                               */
/* Purpose: constructor for the YesNoDialog class                            */
/* Parameters: parentWindow                                                  */
/* Returns:                                                                  */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                      /* YesNoDialog */
/*---------------------------------------------------------------------------*/

      super( parentWindow );

    }
/*end of YesNoDialog*/


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: YesNoDialog.java                                               */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      java.lang.String command;
                                                  /* actionPerformed */
/*---------------------------------------------------------------------------*/

      command = event.getActionCommand();

      if ( command.equals( YES_BUTTON_LABEL_STRING ) )
        {
          answerBoolean = true;
          dispose();
        }
      else
        ;
    /*end of if on YES_BUTTON_LABEL_STRING*/

      if ( command.equals( NO_BUTTON_LABEL_STRING ) )
        {
          answerBoolean = false;
          dispose();
        }
      else
        ;
    /*end of if on NO_BUTTON_LABEL_STRING*/

    }
/*end of actionPerformed*/


  public
  boolean

  answer()
/*****************************************************************************/
/* Function name: answer                                                     */
/* File name: YesNoDialog.java                                               */
/* Purpose: to give the answer                                               */
/* Parameters:                                                               */
/* Returns: true or false                                                    */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                          /* answer */
/*---------------------------------------------------------------------------*/

      return answerBoolean;

    }
/*end of answer*/


  public
  static
  void

  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: YesNoDialog.java                                               */
/* Purpose: to test the text dialog class                                    */
/* Parameters: args                                                          */
/* Returns:                                                                  */
/* Last modified: 23.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      Frame window = new Frame();
                                                          /* main */
/*---------------------------------------------------------------------------*/

      YesNoDialog dialog = new
        YesNoDialog( window,
                     "Test",
                     "Would it be yes or no?" );
      dialog.show();

      boolean answer =
        dialog.answer();

      if (answer == true)
        System.out.println( "\nYes" );
      else
        System.out.println( "\nNo" );
    /*end of if on answer*/

      System.exit( 0 );

    }
/*end of main*/

} /* end of YesNoDialog */

/*****************************************************************************/
/* End of file: YesNoDialog.java                                             */
/*****************************************************************************/

