/*****************************************************************************/
/* File name: TarGzippedInputStream.java                                     */
/* Purpose: input stream to read from a gzipped tar file                     */
/*                                                                           */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.io.*;
import java.util.zip.*;


public
class
TarGzippedInputStream
                              extends    GZIPInputStream

                              implements TarReadable
{

  private final static String RCSID = "$Header: /d/JTAR12/io/RCS/TarGzippedInputStream.java,v 1.1 1999/05/09 22:22:42 vklimov Exp $";

  private InputStream inputStream;


  public
  TarGzippedInputStream( InputStream inputStream )
                                              throws java.io.IOException
/*****************************************************************************/
/* Function name: TarGzippedInputStream                                      */
/* File name: TarGzippedInputStream.java                                     */
/* Purpose: constructor object to read a gzipped tar                         */
/* Parameters: inputStream                                                   */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                 /* TarGzippedInputStream */
/*---------------------------------------------------------------------------*/

      super( inputStream );
      this.inputStream = inputStream;

    }
/*end of TarGzippedInputStream*/


  public
  void
  close()  throws java.io.IOException
/*****************************************************************************/
/* Function name: close                                                      */
/* File name: TarGzippedInputStream.java                                     */
/* Purpose: to close the stream and the overlaying stream too                */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 07.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                             /* close */
/*---------------------------------------------------------------------------*/

      super.close();
      this.inputStream.close();

    }
/*end of close*/


}/* end of TarGzippedInputStream class*/

/*****************************************************************************/
/* End of file: TarGzippedInputStream.java                                   */
/*****************************************************************************/
