/*****************************************************************************/
/* File name: ResizedButton.java                                             */
/* Purpose: to present buttons of different sizes                            */
/*                                                                           */
/* Last modified: 06.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.awt.*;

public
class

ResizedButton extends Button
{

  final static int DEFAULT_BUTTON_WIDTH = 50;
  final static int DEFAULT_BUTTON_HEIGHT = 30;

  protected int width = DEFAULT_BUTTON_WIDTH;
  protected int heigth = DEFAULT_BUTTON_HEIGHT ;

  public
  ResizedButton( java.lang.String label, int width, int heigth )
    {
      super( label );
      this.width = width;
      this.heigth = heigth;
    }

  public
  ResizedButton( java.lang.String label )
    {
      super( label );
    }

  public
  ResizedButton()
    {
      super();
    }

  public
  Dimension getMinimumSize()
    {
      return new Dimension( width, heigth );
    }

  public
  Dimension getPreferredSize()
    {
      return new Dimension( width, heigth );
    }

} /*end of ResizedButton */

/*****************************************************************************/
/* End of file: ResizedButton.java                                           */
/*****************************************************************************/
