/*****************************************************************************/
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to give user an option to choose multiple files                  */
/*                                                                           */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import util.*;

public
class

MultipleFileDialog extends Dialog

                   implements ActionListener,
                              ItemListener

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/io/RCS/MultipleFileDialog.java,v 1.13 1999/05/23 19:42:13 vklimov Exp $";

  private final static int MAX_ROWS_NUMBER    = 3;
  private final static int DEFAULT_COLUMNS_NUMBER = 77;

  private final static java.lang.String DIRECTORY_TEXTFIELD_LABEL =
                                                                "Directory: ";
  private final static java.lang.String DIRECTORY_LABEL_BORDER_LAYOUT_PLACE =
                                                                       "West";
  private final static java.lang.String DIRECTORY_PATH_TEXT_FIELD_PLACE  =
                                                                      "Center";
  private final static java.lang.String SELECTED_FILE_TEXT_FIELD_LAYOUT_PLACE=
                                                                      "Center";
  private final static int N_COLS_DEFAULT_SELECTED_FILE_TEXT_FIELD = 50;

  private final static int DIRECTORY_PANEL_LAYOUT_HGAP         = 3;

  private final static int SOURCE_FILES_LISTS_N_LINES          = 10;
  private final static int SOURCE_FILES_LISTS_WIDTH  = 166;
  private final static int SOURCE_FILES_LISTS_HEIGHT = 150;
  private final static java.lang.String LISTS_PANEL_SUBDIRS_PLACE = "West";
  private final static java.lang.String LISTS_PANEL_FILES_PLACE   = "East";
  private final static int LISTS_PANEL_LAYOUT_HGAP = 11;

  private final static java.lang.String SELECTED_LIST_MESSAGE =
                            "You may deselect any item by clicking on it";

  private final static int SELECTED_FILES_LISTS_N_LINES        =  5;

  private final static int SELECTED_FILES_LIST_WIDTH  = 330;   
  private final static int SELECTED_FILES_LIST_HEIGHT = 70;

  private final static java.lang.String SELECTED_PANEL_HEADER_PLACE = "North";
  private final static java.lang.String SELECTED_PANEL_MESSAGE_PLACE = "South";

  private final static java.lang.String OK_BUTTON_LABEL_STRING = "OK";
  private final static java.lang.String UPDATE_BUTTON_LABEL_STRING = "Update";
  private final static java.lang.String CANCEL_BUTTON_LABEL_STRING = "Cancel";

  private static java.lang.String collatorRulesString =
    " < '.' < 0 < 1 < 2 < 3 < 4 < 5 < 6 < 7 < 8 < 9 < A < B < C < D < E < F < G < H < I < J  < K < L < M < N < O < P < Q < R < S < T  < U < V < W < X < Y < Z < a < b < c < d < e < f < g < h < i < j  < k < l < m < n < o < p < q < r < s < t  < u < v < w < x < y < z ";

  private final static int LOWER_PANEL_BUTTON_WIDTH   = 55;
  private final static int LOWER_PANEL_BUTTON_HEIGHT  = 30;
  private final static int LOWER_PANEL_HORIZONTAL_GAP = 21;
  private final static int LOWER_PANEL_VERTICAL_GAP   = 7;

  final static java.lang.String WARND_TITLE   = "Warning";
  final static int    WARND_ROWS    = 1;
  final static int    WARND_COLUMNS = 55;

  final static java.lang.String MSG_WRONG_SAVE_OR_LOAD_SINGLE_FILE =
                                  "MultipleFileDialog constructor called\n" +
                                  "with wrong value " +
                                  "for the saveOrLoadSingleFile argument:\n" +
                                  "must be java.awt.FileDialog.LOAD or " +
                                  "java.awt.FileDialog.SAVE";

  Panel listsPanel;
  ResizedButton okButton;
  ResizedButton updateButton;
  ResizedButton cancelButton;
  TextField directoryPathTextField;
  io.ResizedList subDirsList;
  io.ResizedList filesList;
  io.ResizedList selectedFilesList;
  TextField selectedFileTextField;

  private java.lang.String[] selectedFilesPaths = null;
  private java.lang.String currentDirFullPath = null;
  final private java.lang.String userWorkingDirFullPath =
                             util.Directory.
                               getCurrentDirFullPath();

  private boolean multipleFilesSelectable = true;
  private int     saveOrLoadSingleFile =
                    general.Constants.JAVA_ERROR_CODE;

  Frame parentWindow;
  SelectedFileTextFieldActionListener
    selectedFileTextFieldActionListener;

  private Filable fileSystem = null;


  public
  void
  addItemsToWindowLists( java.lang.String dirFullPath,
                         io.ResizedList subDirsList,
                         io.ResizedList filesList      )
/*****************************************************************************/
/* Function name: addItemsToWindowLists                                      */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to add contents of the directory to the lists                    */
/* Parameters: dirFullPath                                                   */
/*             subDirsList                                                   */
/*             filesList                                                     */
/* Returns:                                                                  */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      File fileRegularObjectForDirFullPath;
      File fileRegularObjectForElementFile;
      RamFile ramFileForElementFile;
      RamFile ramFileForDirFullPath;
      FileResource dirFile = null;
      FileResource elementFile = null;
      java.lang.String[] contents = null;
      java.lang.String dirParent = null;
      util.String utilStringForSorting;
                                                /* addItemsToWindowLists */
/*---------------------------------------------------------------------------*/

      try
        {
          if (fileSystem == (Filable) null)            /* use regular File */
            {
              fileRegularObjectForDirFullPath = new
                RegularFile( dirFullPath );
              dirFile = new
                FileResource( (Filable)
                  fileRegularObjectForDirFullPath );
            }
          else
            {
              ramFileForDirFullPath =
                ( (RamFile) fileSystem).
                  findElement( dirFullPath );
              if (ramFileForDirFullPath != null)
                dirFile = new
                  FileResource( (Filable)
                    ramFileForDirFullPath );
              else
                ;
            /*end of if on ramFileForDirFullPath*/
            }
        /*end of if on null*/

          contents = dirFile.list();
          dirParent = dirFile.getParent();
          utilStringForSorting = new
            util.String( collatorRulesString );
          contents = utilStringForSorting.sort( contents );
        }
      catch( NullPointerException e )
        {
          return;                                      /* return ! */
        }
      catch( SecurityException e )
        {
          return;                                      /* return ! */
        }
    /*end of try-catch*/

      if (dirParent != (java.lang.String) null )
        subDirsList.addItem( general.Constants.
                             PARENT_DIRECTORY_ABBREVIATION );
      else
        ;
    /*end of if on null*/

      if ( ! dirFullPath.endsWith( File.separator ) )
        dirFullPath = dirFullPath + File.separator;
      else
        ;
    /*end of if on endsWith*/

      for( i=0; i<contents.length; i++)
        {
          try
            {
              if (fileSystem == (Filable) null)         /* use regular File */
                {
                  fileRegularObjectForElementFile = new
                    RegularFile( dirFullPath + contents[i] );
                  elementFile = new
                    FileResource( (Filable)
                      fileRegularObjectForElementFile );
                }
              else
                {
                  ramFileForElementFile =
                    ( (RamFile) fileSystem).
                      findElement( dirFullPath + contents[i] );
                  if (ramFileForElementFile != null)
                    elementFile = new
                      FileResource( (Filable)
                        ramFileForElementFile );
                  else
                    ;
                /*end of if on ramFileForElementFile*/
                }
            /*end of if on null*/

              if ( elementFile.isDirectory() )
                {
                  subDirsList.addItem( contents[i] );
                }
              else
                {
                }
            /*end of if on isDirectory*/

              if ( elementFile.isFile() )
                {
                  filesList.addItem( contents[i] );
                }
              else
                {
                }
            /*end of if on isDirectory*/

            }
          catch( NullPointerException e )
            {
              continue;                                  /* continue */
            }
          catch( SecurityException e )
            {
              continue;                                  /* continue */
            }
        /*end of try-catch*/
        }
    /*end of for-loop*/

    }
/*end of addItemsToWindowLists*/


  public
  MultipleFileDialog( Frame parentWindow,
                      java.lang.String title,
                      java.lang.String textToDisplay,
                      java.lang.String selectedFilesListHeader,
                      boolean mode,
                      Filable fileSystem                         )
/*****************************************************************************/
/* Function name: MultipleFileDialog                                         */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: constructor for the MultipleFileDialog class                     */
/* Parameters: parentWindow                                                  */
/*             title                                                         */
/*             textToDisplay                                                 */
/*             selectedFilesListHeader                                       */
/*             mode - true if modal, false - otherwise                       */
/*             fileSystem - a filesystem object implementing Filable         */
/*                          interface.                                       */
/*                          If this is  null  then the regular java.io.File  */
/*                          will be used to get current directory e.t.c.     */
/* Returns:                                                                  */
/* Last modified: 17.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      super( parentWindow, title, mode );

      BorderLayout listsPanelLayout;
      Panel promptPanel    = new Panel();
      Panel directoryPanel = new Panel();
      Panel selectedHeaderPanel = new Panel();
      Panel selectedFilesPanel = new Panel();
      Panel buttonPanel    = new Panel();
      GridBagConstraints c = new GridBagConstraints();
      GridBagLayout      dialogLayout;
      BorderLayout       directoryPanelLayout;
      Label prompt;
      Label directoryLabel;
      Label selectedListHeaderLabel;
      Label selectedListMessageLabel;

      int nNewlines = 0;
      int nRows = 0;
                                                   /* MultipleFileDialog */
/*---------------------------------------------------------------------------*/

      this.parentWindow = parentWindow;
      this.fileSystem = fileSystem;

      listsPanel = new Panel();
      listsPanelLayout = new BorderLayout();
      listsPanelLayout.setHgap( LISTS_PANEL_LAYOUT_HGAP );
      listsPanel.setLayout( listsPanelLayout );

      dialogLayout = new GridBagLayout();
      setLayout( dialogLayout );

      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      c.weighty = 0.10;
      c.gridwidth = GridBagConstraints.REMAINDER; //end of row
      c.gridheight = 6;
      dialogLayout.setConstraints( promptPanel, c );

      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      c.weighty = 0.10;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = 6;
      dialogLayout.setConstraints( directoryPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.37;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = 6;
      dialogLayout.setConstraints( listsPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.10;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = 6;
      dialogLayout.setConstraints( selectedHeaderPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.20;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = GridBagConstraints.RELATIVE; //end of row
      dialogLayout.setConstraints( selectedFilesPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.13;
      c.gridwidth = GridBagConstraints.REMAINDER; //end of row
      c.gridheight = GridBagConstraints.REMAINDER; //end of row
      dialogLayout.setConstraints( buttonPanel, c );

      prompt = new Label( textToDisplay );
      promptPanel.add( prompt );
      add( promptPanel );

      directoryLabel = new Label( DIRECTORY_TEXTFIELD_LABEL );
      directoryPanelLayout = new BorderLayout();
      directoryPanelLayout.setHgap( DIRECTORY_PANEL_LAYOUT_HGAP );
      directoryPanel.setLayout( directoryPanelLayout );

      directoryPanel.add( directoryLabel,
                          DIRECTORY_LABEL_BORDER_LAYOUT_PLACE );

      if (fileSystem == (Filable) null)
        currentDirFullPath = userWorkingDirFullPath;
      else
        currentDirFullPath = File.separator;
    /*end of if on null*/

      directoryPathTextField = new TextField( currentDirFullPath );
      directoryPathTextField.setEditable( true );
      directoryPathTextField.
        addActionListener( new
          directoryPathTextFieldActionListener() );
      directoryPanel.add( directoryPathTextField,
                          DIRECTORY_PATH_TEXT_FIELD_PLACE );

      add( directoryPanel );

      subDirsList = new
        io.ResizedList( SOURCE_FILES_LISTS_N_LINES,
                        true,
                        SOURCE_FILES_LISTS_WIDTH,
                        SOURCE_FILES_LISTS_HEIGHT   );
      subDirsList.addItemListener( this );
      subDirsList.addActionListener( this );
      listsPanel.add( subDirsList,
                      LISTS_PANEL_SUBDIRS_PLACE );

      filesList = new
        io.ResizedList( SOURCE_FILES_LISTS_N_LINES,
                        true,
                        SOURCE_FILES_LISTS_WIDTH,
                        SOURCE_FILES_LISTS_HEIGHT   );
      listsPanel.add( filesList,
                      LISTS_PANEL_FILES_PLACE );
      filesList.addItemListener( this );
      filesList.addActionListener( this );

      addItemsToWindowLists( currentDirFullPath,
                             subDirsList,
                             filesList           );

      add( listsPanel );

      selectedListHeaderLabel = new Label( selectedFilesListHeader,
                                           Label.CENTER             );
      selectedListMessageLabel = new Label( SELECTED_LIST_MESSAGE,
                                            Label.CENTER            );
      selectedHeaderPanel.setLayout( new BorderLayout() );
      selectedHeaderPanel.add( selectedListHeaderLabel,
                               SELECTED_PANEL_HEADER_PLACE );
      selectedHeaderPanel.add( selectedListMessageLabel,
                               SELECTED_PANEL_MESSAGE_PLACE );
      add( selectedHeaderPanel );

      selectedFilesList = new
        ResizedList( SELECTED_FILES_LISTS_N_LINES,
                     true,
                     SELECTED_FILES_LIST_WIDTH,
                     SELECTED_FILES_LIST_HEIGHT );

      selectedFilesPanel.add( selectedFilesList );
      selectedFilesList.addItemListener( this );
      selectedFilesList.addActionListener( this );
      add( selectedFilesPanel );

      okButton = new ResizedButton( OK_BUTTON_LABEL_STRING,
                                    LOWER_PANEL_BUTTON_WIDTH,
                                    LOWER_PANEL_BUTTON_HEIGHT     );
      updateButton = new ResizedButton( UPDATE_BUTTON_LABEL_STRING,
                                        LOWER_PANEL_BUTTON_WIDTH,
                                        LOWER_PANEL_BUTTON_HEIGHT    );
      cancelButton = new ResizedButton( CANCEL_BUTTON_LABEL_STRING,
                                        LOWER_PANEL_BUTTON_WIDTH,
                                        LOWER_PANEL_BUTTON_HEIGHT    );

      okButton.addActionListener( this );
      updateButton.addActionListener( this );
      cancelButton.addActionListener( this );

      buttonPanel.
        setLayout( new GridLayout( 0, 3, /* columns */
                                   LOWER_PANEL_HORIZONTAL_GAP,
                                   LOWER_PANEL_VERTICAL_GAP   ) );

      buttonPanel.add(okButton);
      buttonPanel.add(updateButton);
      buttonPanel.add(cancelButton);

      add( buttonPanel );

      pack();

    }
/*end of MultipleFileDialog*/



  public
  MultipleFileDialog( Frame parentWindow,
                      java.lang.String title,
                      java.lang.String textToDisplay,
                      java.lang.String selectedFileHeader,
                      boolean mode,
                      boolean multipleFilesSelectable,
                      int     saveOrLoadSingleFile,
                      Filable fileSystem                    )

                                             throws IllegalArgumentException

/*****************************************************************************/
/* Function name: MultipleFileDialog                                         */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: constructor for the MultipleFileDialog class                     */
/* Parameters: parentWindow                                                  */
/*             title                                                         */
/*             textToDisplay                                                 */
/*             selectedFileHeader                                            */
/*             mode - true if modal, false - otherwise                       */
/*             multipleFilesSelectable - true if multiple files may be       */
/*                                        selected,                          */
/*                                    false if only one file may be selected */
/*             saveOrLoadSingleFile - may be                                 */
/*                                    java.awt.FileDialog.SAVE - create      */
/*                                       a new file - or                     */
/*                                    java.awt.FileDialog.LOAD - work        */
/*                                       on an existing file                 */
/*             fileSystem - a filesystem object implementing Filable         */
/*                          interface.                                       */
/*                          If this is  null  then the regular java.io.File  */
/*                          will be used to get current directory e.t.c.     */
/* Throws:  IllegalArgumentException if saveOrLoadSingleFile is not SAVE or  */
/*                                                                  LOAD     */
/* Returns:                                                                  */
/* Last modified: 17.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      super( parentWindow, title, mode );

      BorderLayout listsPanelLayout;
      Panel promptPanel    = new Panel();
      Panel directoryPanel = new Panel();
      Panel selectedHeaderPanel = new Panel();
      Panel selectedFilesPanel = new Panel();
      Panel buttonPanel    = new Panel();
      GridBagConstraints c = new GridBagConstraints();
      GridBagLayout      dialogLayout;
      BorderLayout       directoryPanelLayout;
      BorderLayout       selectedFilesPanelLayout;
      Label prompt;
      Label directoryLabel;
      Label selectedListHeaderLabel;

      int nNewlines = 0;
      int nRows = 0;
                                                   /* MultipleFileDialog */
/*---------------------------------------------------------------------------*/

      if ( (saveOrLoadSingleFile != java.awt.FileDialog.SAVE) &&
           (saveOrLoadSingleFile != java.awt.FileDialog.LOAD)
         )
        throw new IllegalArgumentException(                    /* throw ! */
                    MSG_WRONG_SAVE_OR_LOAD_SINGLE_FILE );
      else
        this.saveOrLoadSingleFile = saveOrLoadSingleFile;
    /*end of if*/

      this.parentWindow = parentWindow;
      this.multipleFilesSelectable = multipleFilesSelectable;
      this.fileSystem = fileSystem;

      listsPanel = new Panel();
      listsPanelLayout = new BorderLayout();
      listsPanelLayout.setHgap( LISTS_PANEL_LAYOUT_HGAP );
      listsPanel.setLayout( listsPanelLayout );

      dialogLayout = new GridBagLayout();
      setLayout( dialogLayout );

      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      c.weighty = 0.10;
      c.gridwidth = GridBagConstraints.REMAINDER; //end of row
      c.gridheight = 6;
      dialogLayout.setConstraints( promptPanel, c );

      c.fill = GridBagConstraints.HORIZONTAL;
      c.weightx = 1.0;
      c.weighty = 0.10;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = 6;
      dialogLayout.setConstraints( directoryPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.37;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = 6;
      dialogLayout.setConstraints( listsPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.10;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = 6;
      dialogLayout.setConstraints( selectedHeaderPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.20;
      c.gridwidth = GridBagConstraints.REMAINDER;
      c.gridheight = GridBagConstraints.RELATIVE; //end of row
      dialogLayout.setConstraints( selectedFilesPanel, c );

      c.fill = GridBagConstraints.BOTH;
      c.weightx = 1.0;
      c.weighty = 0.13;
      c.gridwidth = GridBagConstraints.REMAINDER; //end of row
      c.gridheight = GridBagConstraints.REMAINDER; //end of row
      dialogLayout.setConstraints( buttonPanel, c );

      prompt = new Label( textToDisplay );
      promptPanel.add( prompt );
      add( promptPanel );

      directoryLabel = new Label( DIRECTORY_TEXTFIELD_LABEL );
      directoryPanelLayout = new BorderLayout();
      directoryPanelLayout.setHgap( DIRECTORY_PANEL_LAYOUT_HGAP );
      directoryPanel.setLayout( directoryPanelLayout );

      directoryPanel.add( directoryLabel,
                          DIRECTORY_LABEL_BORDER_LAYOUT_PLACE );

      if (fileSystem == (Filable) null)
        currentDirFullPath = userWorkingDirFullPath;
      else
        currentDirFullPath = File.separator;
    /*end of if on null*/

      directoryPathTextField = new TextField( currentDirFullPath );
      directoryPathTextField.setEditable( true );
      directoryPathTextField.
        addActionListener( new
          directoryPathTextFieldActionListener() );
      directoryPanel.add( directoryPathTextField,
                          DIRECTORY_PATH_TEXT_FIELD_PLACE );

      add( directoryPanel );

      subDirsList = new
        io.ResizedList( SOURCE_FILES_LISTS_N_LINES,
                        multipleFilesSelectable,
                        SOURCE_FILES_LISTS_WIDTH,
                        SOURCE_FILES_LISTS_HEIGHT   );
      subDirsList.addItemListener( this );
      subDirsList.addActionListener( this );
      listsPanel.add( subDirsList,
                      LISTS_PANEL_SUBDIRS_PLACE );

      filesList = new
        io.ResizedList( SOURCE_FILES_LISTS_N_LINES,
                        multipleFilesSelectable,
                        SOURCE_FILES_LISTS_WIDTH,
                        SOURCE_FILES_LISTS_HEIGHT   );
      listsPanel.add( filesList,
                      LISTS_PANEL_FILES_PLACE );
      filesList.addItemListener( this );
      filesList.addActionListener( this );

      addItemsToWindowLists( currentDirFullPath,
                             subDirsList,
                             filesList           );

      add( listsPanel );

      selectedListHeaderLabel = new Label( selectedFileHeader,
                                           Label.CENTER             );
      selectedHeaderPanel.setLayout( new BorderLayout() );
      selectedHeaderPanel.add( selectedListHeaderLabel,
                               SELECTED_PANEL_HEADER_PLACE );
      add( selectedHeaderPanel );

      selectedFilesPanelLayout =  new BorderLayout();
      selectedFilesPanel.setLayout( selectedFilesPanelLayout );

      selectedFileTextField = new
        TextField( N_COLS_DEFAULT_SELECTED_FILE_TEXT_FIELD );
      selectedFileTextField.setEditable( true );
      selectedFileTextFieldActionListener = new
        SelectedFileTextFieldActionListener();
      selectedFileTextField.addActionListener(
        selectedFileTextFieldActionListener    );
      selectedFilesPanel.add( selectedFileTextField,
                              SELECTED_FILE_TEXT_FIELD_LAYOUT_PLACE );
      add( selectedFilesPanel );

      okButton = new ResizedButton( OK_BUTTON_LABEL_STRING,
                                    LOWER_PANEL_BUTTON_WIDTH,
                                    LOWER_PANEL_BUTTON_HEIGHT     );
      updateButton = new ResizedButton( UPDATE_BUTTON_LABEL_STRING,
                                        LOWER_PANEL_BUTTON_WIDTH,
                                        LOWER_PANEL_BUTTON_HEIGHT    );
      cancelButton = new ResizedButton( CANCEL_BUTTON_LABEL_STRING,
                                        LOWER_PANEL_BUTTON_WIDTH,
                                        LOWER_PANEL_BUTTON_HEIGHT    );

      okButton.addActionListener( this );
      updateButton.addActionListener( this );
      cancelButton.addActionListener( this );

      buttonPanel.
        setLayout( new GridLayout( 0, 3, /* columns */
                                   LOWER_PANEL_HORIZONTAL_GAP,
                                   LOWER_PANEL_VERTICAL_GAP   ) );

      buttonPanel.add(okButton);
      buttonPanel.add(updateButton);
      buttonPanel.add(cancelButton);

      add( buttonPanel );

      pack();

      
    }
/*end of MultipleFileDialog*/


  public
  java.lang.String[]

  getPaths()
/*****************************************************************************/
/* Function name: getPaths                                                   */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to get an array of strings - paths of files selected             */
/*          in the dialog                                                    */
/* Parameters:                                                               */
/* Returns: array of strings - paths of selected files                       */
/*          or null if no files were selected                                */
/* Last modified: 05.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      int n;
                                                     /* getPaths */
/*---------------------------------------------------------------------------*/

      if ( ! multipleFilesSelectable )
        {
          if (selectedFilesPaths ==
              (java.lang.String[]) null)
            return selectedFilesPaths;                     /* return ! */
          else
            ;
        /*end of if on empty string*/

          if (selectedFilesPaths[0] == "")
            selectedFilesPaths =
              (java.lang.String[]) null;
          else
            ;
        /*end of if on empty string*/

          return selectedFilesPaths;                     /* return ! */
        }
      else
        ;
    /*end of if on multipleFilesSelectable*/

      n = selectedFilesList.getItemCount();

      if (n == 0)
        return (java.lang.String[]) null;              /* return ! */
      else
        ;
    /*end of if on 0*/

      selectedFilesPaths = new java.lang.String[ n ];

      for (i=0; i<n; i++)
        selectedFilesPaths[i] = selectedFilesList.
          getItem( i );
    /*end of for-loop*/

      return selectedFilesPaths;

     }
/*end of getPaths*/


  public
  void

  removeItemFromSelectedList( List sourceList,
                              int n,
                              java.lang.String listItemToRemove  )
/*****************************************************************************/
/* Function name: removeItemFromSelectedList                                 */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to remove a source list item from a list of selected items       */
/* Parameters: sourceList                                                    */
/*             n - number of the item to remove in the source list           */
/*             listItemToRemove - the item to remove from the selected list  */
/* Returns:                                                                  */
/* Last modified: 29.04.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      java.lang.String currentListItem;
      int countItemsSelectedFilesList;
      boolean continueToLoop = true;
                                            /* removeItemFromSelectedList */
/*---------------------------------------------------------------------------*/

      countItemsSelectedFilesList =
        selectedFilesList.getItemCount();

      for (i=countItemsSelectedFilesList-1;
           ( (i>=0) &&
             continueToLoop
           );                 i--)
        {
          currentListItem = selectedFilesList.getItem( i );
          if (currentListItem.endsWith( listItemToRemove ) )
            {
              selectedFilesList.delItem( i );
              continueToLoop = false;
            }
          else
            ;
        /*end of if*/
        }
    /*end of for-loop*/

    }
/*end of removeItemFromSelectedList*/


  public
  void

  processDoubleClickOnSubDirsListItem(
    List sourceList,
    int i,
    java.lang.String listItemToChangeDirectoryTo  )
/*****************************************************************************/
/* Function name: processDoubleClickOnSubDirsListItem                        */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to change directory                                              */
/* Parameters: sourceList                                                    */
/*             i - number of the item to remove in the source list           */
/*             listItemToChangeDirectoryTo - the item to remove              */
/*                                           from the selected list          */
/* Returns:                                                                  */
/* Last modified: 20.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      File fileRegularObjectForCurrentDirFullPath;
      FileResource dirFile = null;
      RamFile ramFileForCurrentDirFullPath;
      java.lang.String dirParent = null;
                                   /* processDoubleClickOnSubDirsListItem */
/*---------------------------------------------------------------------------*/


      if ( listItemToChangeDirectoryTo.equals(
             general.Constants.
               PARENT_DIRECTORY_ABBREVIATION ) )       /* go to parent dir */
        {
          if (currentDirFullPath == (java.lang.String) null)
            return;                                           /* return ! */
          else
            ;
        /*end of if on null*/

          if (fileSystem == (Filable) null)            /* use regular File */
            {
              fileRegularObjectForCurrentDirFullPath = new
                RegularFile( currentDirFullPath );
              dirFile = new
                FileResource( (Filable)
                  fileRegularObjectForCurrentDirFullPath );
            }
          else                                         /* use the fileSystem */
            {
              ramFileForCurrentDirFullPath =
                ( (RamFile) fileSystem).
                  findElement( currentDirFullPath );
              if (ramFileForCurrentDirFullPath != null)
                dirFile = new
                  FileResource( (Filable)
                    ramFileForCurrentDirFullPath );
              else
                ;
            /*end of if on ramFileForElementFile*/
            }
        /*end of if on null*/
          dirParent = dirFile.getParent();
          currentDirFullPath = dirParent;
        }
      else /* go to a subdir */
        {
          if (currentDirFullPath.endsWith( File.separator ))
            currentDirFullPath = currentDirFullPath +
              listItemToChangeDirectoryTo;
          else
            currentDirFullPath = currentDirFullPath +
              File.separator + listItemToChangeDirectoryTo;
        /*end of if on endsWith*/
        }
    /*end of if on ..*/
      subDirsList.removeAll();
      filesList.removeAll();
      directoryPathTextField.
        setText( currentDirFullPath );

      addItemsToWindowLists( currentDirFullPath,
                             subDirsList,
                             filesList           );

    }
/*end of processDoubleClickOnSubDirsListItem*/


  public
  void

  actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 06.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      int countItemsSubDirsList;
      int countItemsFilesList;
      java.lang.String command;
      java.lang.String listItem;
      boolean continueToLoop = true;
      ActionEvent
        actionEventForSelectedFileTextField;
                                                  /* actionPerformed */
/*---------------------------------------------------------------------------*/

      command = event.getActionCommand();

      if ( command.equals( OK_BUTTON_LABEL_STRING ) )
        {

          if ( ! multipleFilesSelectable )             /* single file */
            {
              actionEventForSelectedFileTextField = new
                ActionEvent( (Object) selectedFileTextField,
                             ActionEvent.ACTION_FIRST,
                             selectedFileTextField.getText() );
              selectedFileTextFieldActionListener.
                actionPerformed(
                  actionEventForSelectedFileTextField );
            }
          else
            ;
        /*end of if on multipleFilesSelectable*/

          setVisible( false );
        }
      else
        ;
    /*end of if on OK_BUTTON_LABEL_STRING*/

      if ( command.equals( CANCEL_BUTTON_LABEL_STRING ) )
        {
          setVisible( false );
          if (multipleFilesSelectable)
            selectedFilesList.removeAll();
          else /* single file */
            selectedFilesPaths =
              (java.lang.String[]) null;
        /*end of if on multipleFilesSelectable*/
        }
      else
        ;
    /*end of if on CANCEL_BUTTON_LABEL_STRING*/

      if ( command.equals( UPDATE_BUTTON_LABEL_STRING ) )
        {
          subDirsList.removeAll();
          filesList.removeAll();
          directoryPathTextField.
            setText( currentDirFullPath );
          addItemsToWindowLists( currentDirFullPath,
                                 subDirsList,
                                 filesList           );
          if ( ! multipleFilesSelectable)
            {
              selectedFilesPaths =
                (java.lang.String[]) null;
              selectedFileTextField.setText( "" );
            }
          else
            ;
        /*end of if on multipleFilesSelectable*/
        }
      else
        ;
    /*end of if on UPDATE_BUTTON_LABEL_STRING*/

      countItemsSubDirsList = subDirsList.getItemCount();
      countItemsFilesList = filesList.getItemCount();

      for (i=0;
           ( (i<countItemsSubDirsList) &&
             continueToLoop
           ); i++)
        {
          listItem = subDirsList.getItem( i );
          if ( command.equals( listItem ) )
            {
              if ( ! multipleFilesSelectable)
                {
                  selectedFilesPaths =
                    (java.lang.String[]) null;
                  selectedFileTextField.setText( "" );
                }
              else
                removeItemFromSelectedList(
                  (List) subDirsList,
                  i,
                  listItem                           );
            /*end of if on multipleFilesSelectable*/

              processDoubleClickOnSubDirsListItem(
                (List) subDirsList,
                i,
                listItem                           );
              continueToLoop = false;
            }
          else
            ;
        /*end of if*/
        }
    /*end of for-loop on subDirsList*/

      if (multipleFilesSelectable)
        {
          for (i=0;
               ( (i<countItemsFilesList) &&
                 continueToLoop
               );                        i++)
            {
              listItem = filesList.getItem( i );
              if ( command.equals( listItem ) )
                {
                  removeItemFromSelectedList(
                    (List) filesList,
                    i,
                    listItem                           );
                  continueToLoop = false;
                }
              else
                ;
            /*end of if*/
            }
        /*end of for-loop on filesList*/
        }
      else
        ;
    /*end of if on multipleFilesSelectable*/
    }
/*end of actionPerformed*/



  public
  void

  processMultipleSelectOnFilesList( ItemEvent event,
                                    List listOfFiles,
                                    int  stateChange   )
/*****************************************************************************/
/* Function name: processMultipleSelectOnFilesList                           */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process a select/deselect event on a list of files            */
/* Parameters: event                                                         */
/*             listOfFiles                                                   */
/*             stateChange                                                   */
/* Returns:                                                                  */
/* Last modified: 04.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      Object item;
      int    itemNumber = 0;
      int    nItemsSelectedFilesList;

      ItemSelectable itemSelectable;
      java.lang.String fullPathOfSelected = null;

                                     /* processMultipleSelectOnFilesList */
/*---------------------------------------------------------------------------*/

      item = event.getItem();
      itemNumber = ((Integer) item).intValue();

      if (currentDirFullPath.endsWith( File.separator ))
        fullPathOfSelected = currentDirFullPath +
          listOfFiles.getItem( itemNumber );
      else
        fullPathOfSelected = currentDirFullPath + File.separator +
          listOfFiles.getItem( itemNumber );
    /*end of if*/

      if (stateChange == ItemEvent.SELECTED)
        {

          selectedFilesList.addItem( fullPathOfSelected );
          nItemsSelectedFilesList =
            selectedFilesList.getItemCount();
          selectedFilesList.
            makeVisible( nItemsSelectedFilesList-1 );

        }
      else
        ;
    /*end of if*/

      if (stateChange == ItemEvent.DESELECTED)
        {
          try
            {
              selectedFilesList.remove( fullPathOfSelected );
            }
          catch( IllegalArgumentException e )
            {
            }
        /*end of try-catch*/
        }
      else
        ;
    /*end of if*/

    }
/*end of processMultipleSelectOnFilesList*/


  public
  void

  processSingleSelectOnSubDirsList( ItemEvent event,
                                    int  stateChange   )
/*****************************************************************************/
/* Function name: processSingleSelectOnSubDirsList                           */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process a select/deselect event on a list of files            */
/* Parameters: event                                                         */
/*             stateChange                                                   */
/* Returns:                                                                  */
/* Last modified: 04.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      Object item;
      int    itemNumber = 0;
      java.lang.String fullPathOfSelected = null;

                                      /* processSingleSelectOnSubDirsList */
/*---------------------------------------------------------------------------*/

      item = event.getItem();
      itemNumber = ((Integer) item).intValue();

      if (currentDirFullPath.endsWith( File.separator ))
        fullPathOfSelected = currentDirFullPath +
          subDirsList.getItem( itemNumber );
      else
        fullPathOfSelected = currentDirFullPath + File.separator +
          subDirsList.getItem( itemNumber );
    /*end of if*/

      if (stateChange == ItemEvent.SELECTED)
        {
          if (selectedFilesPaths ==
              (java.lang.String[]) null)
            {
              selectedFilesPaths = new
                java.lang.String[ 1 ];
            }
          else
            ;
        /*end of if on null*/

          selectedFilesPaths[0] = fullPathOfSelected;

          selectedFileTextField.
            setText( fullPathOfSelected );

          filesList.deselectAll();

        }
      else
        ;
    /*end of if*/

      if (stateChange == ItemEvent.DESELECTED)
        {
          selectedFilesPaths =
              (java.lang.String[]) null;
          selectedFileTextField.setText( "" );
        }
      else
        ;
    /*end of if*/

    }
/*end of processSingleSelectOnSubDirsList*/


  public
  void

  processSingleSelectOnFilesList( ItemEvent event,
                                  int  stateChange   )
/*****************************************************************************/
/* Function name: processSingleSelectOnFilesList                             */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process a select/deselect event on a list of files            */
/* Parameters: event                                                         */
/*             stateChange                                                   */
/* Returns:                                                                  */
/* Last modified: 04.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      Object item;
      int    itemNumber = 0;
      java.lang.String fullPathOfSelected = null;

                                        /* processSingleSelectOnFilesList */
/*---------------------------------------------------------------------------*/

      item = event.getItem();
      itemNumber = ((Integer) item).intValue();

      if (currentDirFullPath.endsWith( File.separator ))
        fullPathOfSelected = currentDirFullPath +
          filesList.getItem( itemNumber );
      else
        fullPathOfSelected = currentDirFullPath + File.separator +
          filesList.getItem( itemNumber );
    /*end of if*/

      if (stateChange == ItemEvent.SELECTED)
        {

          if (selectedFilesPaths ==
              (java.lang.String[]) null)
            {
              selectedFilesPaths = new
                java.lang.String[ 1 ];
            }
          else
            ;
        /*end of if on null*/

          selectedFilesPaths[0] = fullPathOfSelected;

          selectedFileTextField.
            setText( fullPathOfSelected );

          subDirsList.deselectAll();
        }
      else
        ;
    /*end of if*/

      if (stateChange == ItemEvent.DESELECTED)
        {
          selectedFilesPaths =
              (java.lang.String[]) null;
          selectedFileTextField.setText( "" );
        }
      else
        ;
    /*end of if*/

    }
/*end of processSingleSelectOnFilesList*/



  public
  void

  processSelectionOnSelectedFilesList( ItemEvent event,
                                       int stateChange,
                                       List list         )
/*****************************************************************************/
/* Function name: processSelectionOnSelectedFilesList                        */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process a click on the list of selected files                 */
/* Parameters: event                                                         */
/*             stateChange                                                   */
/*             list                                                          */
/* Returns:                                                                  */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      Object item;
      int    itemNumber = 0;
      java.lang.String itemToRemove;
      int[] subDirsListSelectedIndexes;
      int[] filesListSelectedIndexes;
      java.lang.String subDirsListSelectedItem;
      java.lang.String filesListSelectedItem;
      java.lang.String dirForItemToRemove;
      java.lang.String nameForItemToRemove;
      java.lang.String currentDir;
      File fileRegularObjectForItemToRemove;
      FileResource fileForItemToRemove;
                                   /* processSelectionOnSelectedFilesList */
/*---------------------------------------------------------------------------*/

      if (stateChange == ItemEvent.SELECTED)
        {
          item = event.getItem();
          itemNumber = ((Integer) item).intValue();
          itemToRemove = list.getItem( itemNumber );
          fileRegularObjectForItemToRemove = new RegularFile( itemToRemove );
          fileForItemToRemove = new
            FileResource( (Filable) fileRegularObjectForItemToRemove );
          nameForItemToRemove = fileForItemToRemove.getName();
          dirForItemToRemove = fileForItemToRemove.getParent();
          dirForItemToRemove =
            util.String.removeTrailingPathSeparator(
              dirForItemToRemove                     );
          currentDir =
            util.String.removeTrailingPathSeparator(
               currentDirFullPath                    );
          if ( currentDir.equals( dirForItemToRemove ) )
            {                                          /* look for what */
                                                       /* to deselect   */
              subDirsListSelectedIndexes =
                subDirsList.getSelectedIndexes();
              filesListSelectedIndexes =
                filesList.getSelectedIndexes();

              for (i = 0; i<subDirsListSelectedIndexes.length; i++)
                {
                  subDirsListSelectedItem =
                    subDirsList.getItem(
                      subDirsListSelectedIndexes[i] );
                  if ( subDirsListSelectedItem.
                         equals( nameForItemToRemove ) )
                    subDirsList.deselect(
                      subDirsListSelectedIndexes[i] );
                  else
                    ;
                /*end of if on equals*/
                }
            /*end of for-loop on subDirsListSelectedIndexes*/

              for (i = 0; i<filesListSelectedIndexes.length; i++)
                {
                  filesListSelectedItem =
                    filesList.getItem(
                      filesListSelectedIndexes[i] );
                  if ( filesListSelectedItem.
                         equals( nameForItemToRemove ) )
                    filesList.deselect(
                      filesListSelectedIndexes[i] );
                  else
                    ;
                /*end of if on equals*/
                }
            /*end of for-loop on subDirsListSelectedIndexes*/

            }
          else
            ;
        /*end of if on currentDir*/

          list.delItem( itemNumber );
        }
      else
        ;
    /*end of if*/

    }
/*end of processSelectionOnSelectedFilesList*/


  public
  void

  itemStateChanged( ItemEvent event )
/*****************************************************************************/
/* Function name: itemStateChanged                                           */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 04.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int stateChange;
      ItemSelectable itemSelectable;
                                                  /* itemStateChanged */
/*---------------------------------------------------------------------------*/

      itemSelectable = event.getItemSelectable();
      stateChange = event.getStateChange();

      if (itemSelectable == subDirsList)               /* directories */
        {
          if (multipleFilesSelectable)
            processMultipleSelectOnFilesList(
              event,
              (List) subDirsList,
              stateChange                     );
          else /* single */
            processSingleSelectOnSubDirsList(
              event,
              stateChange                     );
        /*end of if on multipleFilesSelectable*/
        }
      else
        ;
    /*end of if*/

      if (itemSelectable == filesList)                     /* files */
        {
          if (multipleFilesSelectable)
            processMultipleSelectOnFilesList(
              event,
              (List) filesList,
              stateChange         );
          else /* single */
            processSingleSelectOnFilesList(
              event,
              stateChange                     );
        /*end of if on multipleFilesSelectable*/
        }
      else
        ;
    /*end of if*/
                                                       /* selected files */
      if (itemSelectable == selectedFilesList)
        {
          processSelectionOnSelectedFilesList(
            event,
            stateChange,
            (List) selectedFilesList           );
        }
      else
        ;
    /*end of if*/

    }
/*end of itemStateChanged*/



  class

  directoryPathTextFieldActionListener

                         implements ActionListener
    {

      directoryPathTextFieldActionListener()
/*****************************************************************************/
/* Function name: directoryPathTextFieldActionListener                       */
/* Class name: directoryPathTextFieldActionListener                          */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: constructor for the directoryPathTextFieldActionListener class   */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 04.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
                                  /* directoryPathTextFieldActionListener */
/*---------------------------------------------------------------------------*/

        }
/*end of directoryPathTextFieldActionListener*/


      public
      void

      actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* Class name: directoryPathTextFieldActionListener                          */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
          java.lang.String dirName;
          java.lang.String canonicalPath;
          File fileRegularObjectForDirFile;
          FileResource dirFile = null;
          boolean doesExist = true;
          boolean isADirectory = true;
          TextDisplayingDialog warnd;
                                                      /* actionPerformed */
/*---------------------------------------------------------------------------*/

          dirName = event.getActionCommand();

          if ( ! dirName.startsWith( File.separator ) )
            {                                          /* create an absolute */
                                                       /* path               */
              if ( currentDirFullPath.
                     endsWith( File.separator ) )
                dirName = currentDirFullPath + dirName;
              else
                dirName = currentDirFullPath + File.separator +
                  dirName;
            /*end of if on endsWith*/
            }
          else /* this is an absolute path */
            ;
        /*end of if on startsWith*/

          try
            {
              fileRegularObjectForDirFile = new RegularFile( dirName );
              dirFile = new
                FileResource( (Filable) fileRegularObjectForDirFile );
              doesExist = dirFile.exists();
              isADirectory = dirFile.isDirectory();
              canonicalPath = dirFile.getCanonicalPath();
            }
          catch( NullPointerException e )
            {
              warnd = new
                TextDisplayingDialog(
                  parentWindow,
                  WARND_TITLE,
                  "Please enter a valid directory name here",
                  WARND_ROWS,
                  WARND_COLUMNS );
              warnd.show();
              return;                                         /* return ! */
            }
          catch( IOException e )
            {
              warnd = new
                TextDisplayingDialog(
                  parentWindow,
                  WARND_TITLE,
                 "Please enter a full path of a directory here",
                  WARND_ROWS,
                  WARND_COLUMNS );
              warnd.show();
              return;                                         /* return ! */
            }
          catch( SecurityException e )
            {
              warnd = new
                TextDisplayingDialog(
                  parentWindow,
                  WARND_TITLE,
                  "Don\'t have a right to access " +
                     dirName,
                  WARND_ROWS,
                  WARND_COLUMNS );
              warnd.show();
              return;                                         /* return ! */
            }
        /*end of try-catch*/

          if (doesExist && isADirectory)
            {
              currentDirFullPath = canonicalPath;
              subDirsList.removeAll();
              filesList.removeAll();
              addItemsToWindowLists( currentDirFullPath,
                                     subDirsList,
                                     filesList           );
              if ( ! multipleFilesSelectable)
                {
                  selectedFilesPaths =
                   (java.lang.String[]) null;
                  selectedFileTextField.setText( "" );
                }
              else
                ;
            /*end of if on multipleFilesSelectable*/
            }
          else
            {
              if ( ! doesExist )
                {
                  warnd = new
                    TextDisplayingDialog(
                      parentWindow,
                      WARND_TITLE,
                      "Directory " +
                         dirName + " does not exist",
                      WARND_ROWS,
                      WARND_COLUMNS );
                  warnd.show();
                }
              else /* does exist */
                {
                  if ( ! isADirectory )
                    {
                      warnd = new
                        TextDisplayingDialog(
                          parentWindow,
                          WARND_TITLE,
                          "File " +
                             dirName + " is not a directory",
                          WARND_ROWS,
                          WARND_COLUMNS );
                      warnd.show();
                    }
                  else
                    ;
                /*end of if on doesExist*/
                }
            /*end of if on doesExist*/

            }
        /*end of if on not isADirectory*/

          directoryPathTextField.
            setText( currentDirFullPath );

        }
    /*end of actionPerformed*/


    }
/*end of directoryPathTextFieldActionListener*/




  class

  SelectedFileTextFieldActionListener

                         implements ActionListener
    {

      SelectedFileTextFieldActionListener()
/*****************************************************************************/
/* Function name: SelectedFileTextFieldActionListener                        */
/* Class name: SelectedFileTextFieldActionListener                           */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: constructor for the SelectedFileTextFieldActionListener class    */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 06.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
                                  /* SelectedFileTextFieldActionListener */
/*---------------------------------------------------------------------------*/

        }
/*end of SelectedFileTextFieldActionListener*/


      public
      void

      actionPerformed( ActionEvent event )
/*****************************************************************************/
/* Function name: actionPerformed                                            */
/* Class name: SelectedFileTextFieldActionListener                           */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: to process user-initiated events                                 */
/* Parameters: event                                                         */
/* Returns:                                                                  */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
        {
          java.lang.String fileOrDirName;
          java.lang.String canonicalPath;
          File fileRegularObjectForDirOrFile;
          FileResource dirOrRegularFileFileObject = null;
          boolean doesExist = true;
          TextDisplayingDialog warnd;
                                                      /* actionPerformed */
/*---------------------------------------------------------------------------*/

          fileOrDirName = event.getActionCommand();

          if ( ! fileOrDirName.startsWith( File.separator ) )
            {                                          /* create an absolute */
                                                       /* path               */
              if ( currentDirFullPath.
                     endsWith( File.separator ) )
                fileOrDirName = currentDirFullPath + fileOrDirName;
              else
                fileOrDirName = currentDirFullPath + File.separator +
                  fileOrDirName;
            /*end of if on endsWith*/
            }
          else /* this is an absolute path */
            ;
        /*end of if on startsWith*/

          try
            {
              fileRegularObjectForDirOrFile = new
                RegularFile( fileOrDirName );
              dirOrRegularFileFileObject = new
                FileResource( (Filable) fileRegularObjectForDirOrFile );
              doesExist = dirOrRegularFileFileObject.exists();

              if ( (saveOrLoadSingleFile ==
                    java.awt.FileDialog.LOAD) &&
                   ( ! doesExist )                )
                {
                  warnd = new
                    TextDisplayingDialog(
                      parentWindow,
                      WARND_TITLE,
                      "File " + fileOrDirName +
                      " doesn\'t exist",
                      WARND_ROWS,
                      WARND_COLUMNS );
                  warnd.show();
                  selectedFileTextField.
                    setText( "" );
                  subDirsList.deselectAll();
                  filesList.deselectAll();
                  return;                                      /* return ! */
                }
              else
                ;
            /*end of if on doesExist*/

              canonicalPath = dirOrRegularFileFileObject.getCanonicalPath();
              selectedFileTextField.
                setText( canonicalPath );

              if (selectedFilesPaths ==
                  (java.lang.String[]) null)
                {
                  selectedFilesPaths = new
                    java.lang.String[ 1 ];
                }
              else
                ;
            /*end of if on null*/

              selectedFilesPaths[0] = canonicalPath;

            }
          catch( NullPointerException e )
            {
              warnd = new
                TextDisplayingDialog(
                  parentWindow,
                  WARND_TITLE,
                  "Please enter a valid file name here",
                  WARND_ROWS,
                  WARND_COLUMNS );
              warnd.show();
              return;                                         /* return ! */
            }
          catch( IOException e )
            {
              warnd = new
                TextDisplayingDialog(
                  parentWindow,
                  WARND_TITLE,
                 "Please enter a full path of a file here",
                  WARND_ROWS,
                  WARND_COLUMNS );
              warnd.show();
              return;                                         /* return ! */
            }
          catch( SecurityException e )
            {
              warnd = new
                TextDisplayingDialog(
                  parentWindow,
                  WARND_TITLE,
                  "Don\'t have a right to access " +
                     fileOrDirName,
                  WARND_ROWS,
                  WARND_COLUMNS );
              warnd.show();
              return;                                         /* return ! */
            }
        /*end of try-catch*/

        }
    /*end of actionPerformed*/


    }
/*end of SelectedFileTextFieldActionListener*/


  public
  static
  void
  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: MultipleFileDialog.java                                        */
/* Purpose: constructor for the MultipleFileDialog class                     */
/* Parameters: args                                                          */
/* Returns:                                                                  */
/* Last modified: 16.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      boolean result;
      boolean continueToLoop = true;
      RamFile file = null;
      int type = io.Filable.THIS_IS_UNKNOWN_TYPE;
      Frame window = new Frame();
      java.lang.String paths[];
                                                   /* main */
/*---------------------------------------------------------------------------*/

      if (args.length<1)
        {
          System.out.println( "\nUsage: java MultipleFileDialog " +
                              "{multiple | single} [file | ram]\n" );

          System.exit( 0 );
        }
      else
        ;
    /*end of if*/

      if ( args[1].equals( "ram" ) )
        {
          if (args.length<3)
            {
              System.out.println(
                "\nUsage: java MultipleFileDialog " +
                "{multiple | single} ram <path1> <type1> " +
                "[ [ path2 type2 ] ...]" );
              System.out.println( "type: f - for regular file, " +
                                  "d - for directories"            );
              System.exit( 1 );
            }
          else
            ;
        /*end of if on args.length*/

          file = new RamFile();

          i=2;
          while( (i<args.length-1) &&
                 continueToLoop
               )

            {
              if (args[i+1].equals( "f" ) )
                type = io.Filable.THIS_IS_A_REGULAR_FILE;
              else
                if (args[i+1].equals( "d" ))
                  type = io.Filable.THIS_IS_A_DIRECTORY;
                else
                  continueToLoop = false;
              /*end of if on d*/
            /*end of if on f*/

              if (continueToLoop)
                {
                  result =
                    file.addElement( args[i], type );
                  System.out.println( "\ni=" + i +
                                      " was adding " +
                                      args[i] +
                                      "\nresult=" + result );
                  i+=2;
                }
              else
                ;
            /*end of if on continueToLoop*/
            }
        /*end of while-loop*/

          System.out.println( "\nfile=\n" +
                              file.toString() );
        }
      else /* regular file, nothing to do */
        ;
    /*end of if on ram*/

      if ( args[0].equals( "single" ) )
        {
          MultipleFileDialog dialog = new
            MultipleFileDialog( window, "Test of single file selection",
                                "Choose a file and/or directory",
                                "File or directory selected",
                                true,                             /* modal */
                                false,                            /* single */
                                java.awt.FileDialog.LOAD,    /*existing file*/
                                file                       );
          dialog.show();

          paths = dialog.getPaths();

          if (paths == (java.lang.String[]) null)
            System.out.println( "Nothing selected" );
          else
            {
              System.out.println( "Selected file or directory:" );
              for (i=0; i<paths.length; i++)
                {
                  System.out.println( "i=" + i + " " + paths[i] );
                }
            /*end of for-loop*/
            }
        /*end of if on null*/

          System.exit( 0 );

        }
      else /* multiple */
        {
          MultipleFileDialog dialog = new
            MultipleFileDialog( window, "Test with 6 panels",
                                "Choose files and/or directories",
                                "Files and/or directories selected",
                                true,                              /* modal */
                                file                             );
          dialog.show();

          paths = dialog.getPaths();

          if (paths == (java.lang.String[]) null)
            System.out.println( "No files or directories selected" );
          else
            {
              System.out.println( "Selected files and/or directories:" );
              for (i=0; i<paths.length; i++)
                {
                  System.out.println( "i=" + i + " " + paths[i] );
                }
            /*end of for-loop*/
            }
        /*end of if on null*/

          System.exit( 0 );

        }
    /*end of if on single*/

    }
/*end of main*/

} /*end of MultipleFileDialog */

/*****************************************************************************/
/* End of file: MultipleFileDialog.java                                      */
/*****************************************************************************/
