/*****************************************************************************/
/* File name: FileResource.java                                              */
/* Purpose: file system object representing a generic file system            */
/*                                                                           */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/* For the list of authors and contributors of the original C version        */
/* of the GNU tar see files AUTHORS and THANKS                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package io;


public
class

FileResource

{
  private final static String RCSID = "$Header: /d/JTAR12/io/RCS/FileResource.java,v 1.1 1999/05/18 19:51:37 vklimov Exp $";


  private Filable fileObjectToUse;


  public
  FileResource( Filable fileObjectToUse ) 
/*****************************************************************************/
/* Function name: FileResource                                               */
/* File name: FileResource.java                                              */
/* Purpose: constructor for the object to access a generic file system       */
/* Parameters: fileObjectToUse                                               */
/* Returns:                                                                  */
/* Last modified: 14.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* FileResource */
/*---------------------------------------------------------------------------*/

      this.fileObjectToUse = fileObjectToUse;

    }
/*end of FileResource*/



  public
  java.lang.String[]

  list()
/*****************************************************************************/
/* Function name: list                                                       */
/* File name: FileResource.java                                              */
/* Purpose: to return an array of file names contained in this RamFile       */
/*          object representing a directory                                  */
/* Parameters:                                                               */
/* Returns: array of file names or                                           */
/*          null if this is not a directory or there is no files in it       */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                           /* list */
/*---------------------------------------------------------------------------*/

      return fileObjectToUse.list();

    }
/*end of list*/


  public
  java.lang.String

  getParent()
/*****************************************************************************/
/* Function name: getParent                                                  */
/* File name: FileResource.java                                              */
/* Purpose: to return path of the parent directory of this RamFile object    */
/* Parameters:                                                               */
/* Returns: the path string or                                               */
/*          null if there is no parent directory                             */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                          /* getParent */
/*---------------------------------------------------------------------------*/

      return fileObjectToUse.getParent();

    }
/*end of getParent*/


  public
  boolean

  exists()
/*****************************************************************************/
/* Function name: exists                                                     */
/* File name: FileResource.java                                              */
/* Purpose: always returns true for this file system                         */
/* Parameters:                                                               */
/* Returns: true                                                             */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                          /* exists */
/*---------------------------------------------------------------------------*/

      return fileObjectToUse.exists();

    }
/*end of exists*/


  public
  boolean

  isDirectory()
/*****************************************************************************/
/* Function name: isDirectory                                                */
/* File name: FileResource.java                                              */
/* Purpose: to return true if this RamFile object represents a directory     */
/* Parameters:                                                               */
/* Returns: true if this is a directory                                      */
/*          false - if this not a directory                                  */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* isDirectory */
/*---------------------------------------------------------------------------*/

      return fileObjectToUse.isDirectory();

    }
/*end of isDirectory*/


  public
  java.lang.String

  getCanonicalPath()   throws java.io.IOException
/*****************************************************************************/
/* Function name: getCanonicalPath                                           */
/* File name: FileResource.java                                              */
/* Purpose: this method returns just the path string that we have            */
/*          for this RamFile object for this file system                     */
/* Parameters:                                                               */
/* Returns: the path string or                                               */
/*          null if there is no path                                         */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                  /* getCanonicalPath */
/*---------------------------------------------------------------------------*/

      return fileObjectToUse.getCanonicalPath();

    }
/*end of getCanonicalPath*/


  public
  boolean

  isFile()
/*****************************************************************************/
/* Function name: isFile                                                     */
/* File name: RamFile.java                                                   */
/* Purpose: to true if this RamFile object represents a regular file         */
/* Parameters:                                                               */
/* Returns: true - if the is a regular file                                  */
/*          false - otherwise                                                */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                         /* isFile */
/*---------------------------------------------------------------------------*/

      return fileObjectToUse.isFile();

    }
/*end of isFile*/


  public
  java.lang.String

  getName()
/*****************************************************************************/
/* Function name: getName                                                    */
/* File name: FileResource.java                                              */
/* Purpose: to return the name string of this RamFile object                 */
/* Parameters:                                                               */
/* Returns: the name string                                                  */
/* Last modified: 15.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
                                                       /* getName */
/*---------------------------------------------------------------------------*/

      return fileObjectToUse.getName();

    }
/*end of getName*/


}/*end of FileResource class*/

/*****************************************************************************/
/* End of file: FileResource.java                                            */
/*****************************************************************************/
