/*****************************************************************************/
/* File name: Stat.java                                                      */
/* Purpose: to implement C language stat structure                           */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package c;

import java.lang.reflect.*;
import util.*;

public
class

Stat

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/c/RCS/Stat.java,v 1.3 1999/05/04 17:00:37 vklimov Exp $";


  private static final java.lang.String TO_STRING_CLASS_SEPARATOR_STRING = ":";
  private static final java.lang.String TO_STRING_FIELD_SEPARATOR_STRING = "\n";
  private static final java.lang.String TO_STRING_FIELD_DESIGNATOR_STRING = "=";


  public int dev;
  public int ino;
  public int mode;
  public int nlink;
  public int uid;
  public int gid;
  public int  rdev;
  public int  size;
  public int  blksize;
  public int  blocks;
  public int  atime;
  public int  mtime;
  public int  ctime;

  public
  Stat( )
/*****************************************************************************/
/* Function name: Stat                                                       */
/* File name: Stat.java                                                      */
/* Purpose: constructor for the Stat object                                  */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 24.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                           /* Stat */
/*---------------------------------------------------------------------------*/

    }
/*end of Stat*/


  public
  java.lang.String

  toString()
/*****************************************************************************/
/* Function name: toString                                                   */
/* File name: Stat.java                                                      */
/* Purpose: to create String that contains all information on the Stat       */
/*          object                                                           */
/* Parameters:                                                               */
/* Returns: the string                                                       */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      Class  thisClass = null;
      java.lang.String result;
      StringBuffer resultBuffer = new StringBuffer( "" );
      Field[] thisAllFieldsArray = null;
      int i;
                                                         /* toString */
/*---------------------------------------------------------------------------*/

      thisClass = this.getClass();
      try
        {
          thisAllFieldsArray = thisClass.getDeclaredFields();
          resultBuffer.append( thisClass.toString() +
                               TO_STRING_FIELD_SEPARATOR_STRING );
          resultBuffer.append( "the class contains total " +
                               thisAllFieldsArray.length +
                               " fields" );
        }
      catch( SecurityException e )
        {
          util.Error.warn( "SecurityException! " +
                      e.toString()            );
        }
    /*end of try on SecurityException*/

      result = thisClass.toString() +
               TO_STRING_CLASS_SEPARATOR_STRING +
               this.hashCode() +
               TO_STRING_CLASS_SEPARATOR_STRING +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "dev" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               dev +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "ino" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               ino +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "mode" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               mode +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "nlink" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               nlink +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "uid" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               uid +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "gid" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               gid +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "rdev" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               rdev +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "size" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               size +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "blksize" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               blksize +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "blocks" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               blocks +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "atime" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               atime +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "mtime" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               mtime +
               TO_STRING_FIELD_SEPARATOR_STRING +
               "ctime" +
               TO_STRING_FIELD_DESIGNATOR_STRING +
               ctime;

      return result;

    }
/*end of toString*/



  public
  static
  void

  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: Stat.java                                                      */
/* Purpose: to test the Stat class                                           */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 27.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
      c.Stat newStat = new c.Stat();
                                                         /* main */
/*---------------------------------------------------------------------------*/


    }
/*end of main*/

} /*end of class Stat */

/*****************************************************************************/
/* End of file: Stat.java                                                    */
/*****************************************************************************/

