/*****************************************************************************/
/* File name: Byte.java                                                      */
/* Purpose: to implement useful things doable on the C language char type    */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*                                                                           */
/* This program is distributed in the hope that it will be useful, but       */
/* WITHOUT ANY WARRANTY; without even the implied warranty of                */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General */
/* Public License for more details.                                          */
/*                                                                           */
/* This software is distributed under the terms                              */
/* of the GNU General Public License as published                            */
/* by the Free Software Foundation; either version 2, or (at your option)    */
/* any later version.                                                        */
/* See file COPYING for your rights (GNU GPL)                                */
/*****************************************************************************/

package c;

public
class

Byte

{

  private final static java.lang.String RCSID = "$Header: /d/JTAR12/c/RCS/Byte.java,v 1.2 1999/05/04 17:00:36 vklimov Exp $";

  private final static int CODE_INT_ERROR_UNRECOVERABLE = -1;

  private final static java.lang.String IS_SPACE = "is a space";
  private final static java.lang.String IS_NOT_SPACE = "is not a space";
  private final static java.lang.String IS_OCTAL_DIGIT = "is an octal digit";
  private final static java.lang.String IS_NOT_OCTAL_DIGIT = "is not an octal digit";


  Byte( )
/*****************************************************************************/
/* Function name: Byte                                                       */
/* File name: Byte.java                                                      */
/* Purpose: constructor for the Byte object                                  */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 24.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                           /* Byte */
/*---------------------------------------------------------------------------*/

    }
/*end of Byte*/

  public
  static
  boolean
  isspace( byte b )
/*****************************************************************************/
/* Function name: isspace                                                    */
/* File name: Byte.java                                                      */
/* Purpose: to check whether the byte is an octal digit:                     */
/*          from 0 through 7 it is                                           */
/* Parameters: b - the byte to check                                         */
/* Returns: true - if the byte is an octal digit                             */
/*          false - otherwise                                                */
/* Last modified: 24.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* isspace */
/*---------------------------------------------------------------------------*/

      if ( (b == (byte) ' ') ||
           (b == (byte) '\f') ||
           (b == (byte) '\n') ||
           (b == (byte) '\r') ||
           (b == (byte) '\t') ||
           (b == (byte) '\u000b')
         )
        return true;
      else
        return false;
    /*end of if*/

    }
/*end of isspace*/


  public
  static
  boolean
  isodigit( byte b )
/*****************************************************************************/
/* Function name: isodigit                                                   */
/* File name: Byte.java                                                      */
/* Purpose: to check whether the byte is a space:                            */
/*          ' ', '\f', '\n', '\r', '\t' and C '\v' that is '\u000b'          */
/* Parameters: b - the byte to check                                         */
/* Returns: true - if the byte is a space                                    */
/*          false - otherwise                                                */
/* Last modified: 24.09.98                                                   */
/* Author: Victor Klimov, 1998                                               */
/*****************************************************************************/
    {
                                                         /* isodigit */
/*---------------------------------------------------------------------------*/

      if ( (b >= (byte) '0') &&
           (b <= (byte) '7')    )
        return true;
      else
        return false;
    /*end of if*/

    }
/*end of isodigit*/


  public
  static
  void

  main( java.lang.String[] args )
/*****************************************************************************/
/* Function name: main                                                       */
/* File name: Byte.java                                                      */
/* Purpose: to test the class's methods                                      */
/* Parameters:                                                               */
/* Returns:                                                                  */
/* Last modified: 03.05.99                                                   */
/* Author: Victor Klimov, 1999                                               */
/*****************************************************************************/
    {
      int i;
      java.lang.String stringToCheck;
      boolean this_is_a_space;
      boolean this_is_a_octal_digit;
      byte current_byte;
                                                         /* main */
/*---------------------------------------------------------------------------*/

      if (args.length < 1)
        {
        System.out.println( "Usage: java Byte.class \"chars\"" );
        System.exit( CODE_INT_ERROR_UNRECOVERABLE );
        }
      else /* args[0] is ok */
        {
        System.out.println( "characters to check are: " +
                            "\"" + args[0] + "\"" );
        stringToCheck = args[0];
        for (i=0; i<stringToCheck.length();i++)
          {
            current_byte = (byte) stringToCheck.charAt(i);
            this_is_a_space = isspace( current_byte );
            this_is_a_octal_digit = isodigit( current_byte );
            System.out.print( "char\t# " + i +
                                " \'" +
                                stringToCheck.charAt(i) +
                                " \'\t"                   );
            if (this_is_a_space)
              System.out.print( IS_SPACE + "\t" );
            else
              System.out.print( IS_NOT_SPACE + "\t" );
          /*end of if*/

            if (this_is_a_octal_digit)
              System.out.println( IS_OCTAL_DIGIT );
            else
              System.out.println( IS_NOT_OCTAL_DIGIT );
          /*end of if*/

          }
      /*end of for-loop*/
        }
    /*end of if*/

    }
/*end of main*/

} /*end of class Byte */

/*****************************************************************************/
/* End of file: Byte.java                                                    */
/*****************************************************************************/
