/* c4pstart.c - C4P Statup Routines.
   Time-stamp: "97/01/03 18:04:57 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "c4plib.h"

#if defined (_WIN32)
#if defined (MIKTEX_DLL)
#define _MIKTEX_1 __declspec(dllexport)
#endif /* IN_MIKTEX_DLL */
#define _MIKTEX_2 __stdcall
#endif /*  _WIN32 */

#if ! defined (_MIKTEX_1)
#define _MIKTEX_1
#endif /* ! _MIKTEX_1 */

#if ! defined (_MIKTEX_2)
#define _MIKTEX_2
#endif /* ! _MIKTEX_2 */

_MIKTEX_1 integer c4pargc;
_MIKTEX_1 char * c4pargv[20];
_MIKTEX_1 char c4ppline[128];
_MIKTEX_1 integer c4pplen;
_MIKTEX_1 struct tm _c4p_start_time;
_MIKTEX_1 text input;
_MIKTEX_1 text output;

_MIKTEX_1 int _MIKTEX_2
_c4p_startup (int argc,
	      char **argv)

{
  integer i;
  time_t start_time;

  time (&start_time);
  _c4p_start_time = *localtime(&start_time);
  c4pargv[0] = strdup(argv[0]);
  c4pargc = 1;
  *c4ppline = 0;
  for (i=1, c4pargc=1; i<argc; i++, c4pargc++)
    {
      c4pargv[c4pargc] = strdup(argv[i]);
#if 0
      if (c4pargc > 1)
	strcat (c4ppline, " ");
#else
      strcat (c4ppline, " ");
#endif
      strcat (c4ppline, c4pargv[c4pargc]);
    }
  c4pplen = strlen(c4ppline);
  input._c4p_fp = stdin;
  output._c4p_fp = stdout;
  input._c4p_buf = '\n';
  output._c4p_buf = 0;

  return (0);
}
